Summary: Event driven digital circuit simulator with a tcl/tk interface.
Name: tkgate
%define version 1.6g
Version: %{version}
Release: 1
Group: Applications/Simulation
Copyright: GPL
Source: tkgate-%{version}.tgz
URL: http://www.cs.cmu.edu/~hansen/tkgate/
Requires: tcl >= 8, tk >= 8
Packager: Marc Lavall-Ae <odradek@videotron.ca>$)B

%description
TkGate is a event driven digital circuit simulator with a tcl/tk-based
graphical editor. TkGate supports a wide range of primitive circuit
elements as well as user-defined modules for hierarchical design. 
The distribution comes with a number of tutorial and example circuits 
which can be loaded through the "Help" menu. The example circuits include
a simple CPU, programmed to run the Animals game.

TkGate Features:
- Easy to use point-and-click user interface. 
- Customizable color configuration. 
- Intelligent placement and movement of wires. 
- Multi-bit buses. 
- Hierarchical design through user defined modules. 
- Six valued logic including 0, 1, floating, unknown, "low" and "high". 
- Wide range of circuit elements including: 
-      Basic gates (AND, OR, etc.) 
-      Switch-level NMOS and PMOS transistors 
-      Tristate buffers 
-      Alu components (Adders, shifters, multipliers) 
-      Memory elements (Registers, RAMs, ROMs) 
-      A "tty" element which allows the creation of interactive circuits. 
- Graphical display of simulation results. 
- Breakpoints, single-step and clock-step simulator control. 
- Includes a generic microcode/macrocode compiler for creating memory 
  initialization files. 
- Simulations can be controlled through the GUI or through script files. 
- Verilog-like save file format. 
- Hyperlinks to move about in circuit or load other files. 
- Can be configured to use Japanese interface (see README file). 
- Supports static critical path analysis. 

%prep
%setup

%build
./configure
make

%install
make install
make install.man

%files
/usr/X11R6/bin/tkgate
/usr/X11R6/bin/gmac
/usr/X11R6/lib/tkgate-1.6g
%doc /usr/X11R6/man/man1/tkgate.1x
%doc /usr/X11R6/man/man1/gmac.1x
%doc COPYING README doc
