/****************************************************************************
    Copyright (C) 1987-2001 by Jeffery P. Hansen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
****************************************************************************/
#include "tkgate.h"

static iconDimensions xor_iconDims[] = {
  {0, 0, 24, 15, 12, 7},
  {25, 0, 15, 24, 7, 9},
  {16, 25, 24, 15, 11, 7},
  {0, 16, 15, 24, 7, 14},
};
static int xor_iconBoldOffset = 41;

extern struct locate and_out_loc[];
extern struct locate and_in_loc[];

static char *psXOr[] = {
  "%",
  "% 'OR' part of XOR gate",
  "%",
  "/base_xor {",
  "  startgate",
  "  -10 -7 moveto",
  "  -5 7 14 -90 -30 arc",
  "  -5 -7 14 30 90 arc",
  "  14 theight neg 11 sub 0 14 30 -30 arcn",
  "  closepath",
  "  stroke",
  "  grestore",
  "} bind def",
  "%",
  "% An XOR Gate",
  "%",
  "/psxor {",
  "  startgate",
  "  3 0 0 base_xor",
  "  14 theight neg 11 sub 0 14 30 -30 arcn",
  "  stroke",
  "  grestore",
  "} bind def",
  0
};

GGateInfo gate_xor_info = {
  0,
  "XOR",
  "xor:xnor",0x2,
  "psxor",psXOr,

  {{"x",	{"gmgate",0},		{"gmxor",0,0,300},	"gat_make xor"},
   {"X",	{"gmgate",0},		{"gmxnor",0,0,301},	"gat_make xor -invert Z"},
   {"Ctl-r x",	{"gmredgate",0},	{"gmrxor",0,0,300},	"gat_make xor -pins I=1"},
   {"Ctl-r X",	{"gmredgate",0},	{"gmrxnor",0,0,301},	"gat_make xor -pins I=1 -invert Z"},
   {0}
  },

  xor_iconDims,

  2,{{"I",IN,1,2,and_in_loc,1},{"Z",OUT,1,1,and_out_loc,0}},
  {{0,-12,CT},{12,0,LJ},{0,-12,CT},{12,0,LJ}},
  {1},

  {"I-Z",0},
  
  Generic_Make,
  Generic_Init,
  Generic_Delete,
  Generic_GetExtents,
  Generic_HitDistance,
  Generic_Draw,
  Generic_Move,
  Generic_Replicate,
  Generic_AddInput,
  Err_AddOutput,
  Err_AddInOut,
  Err_ChangePin,
  Nop_SimStateFunc,
  Nop_SimHitFunc,
  Generic_PSWrite,
  Generic_EditProps,
  Generic_VerSave
};

void init_xor()
{
  Pixmap P;
  P = Pixmap_registerFromFile("xor","xor.b");
  gateinfo_iconInit(&gate_xor_info,P,xor_iconDims,xor_iconBoldOffset);
  RegisterGate(&gate_xor_info);
}
