/****************************************************************************
    Copyright (C) 1987-2001 by Jeffery P. Hansen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Last edit by hansen on Thu Nov 16 09:58:37 2000
****************************************************************************/
#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include <signal.h>
#include <assert.h>
#include "tkgate.h"

/*
   Returns the log 2 of n rounded up.  That is:

	log2(1) = 1
	log2(2) = 1
	log2(3) = 2
	log2(4) = 2
	log2(5) = 3

    The number of select lines on an n way multiplexor is then log2(n).
*/
int required_bits(int n)
{
  int i,b;

  for (i = b = 0;n; i++) {
    b += (n & 1);
    n >>= 1;
  }

  return i - 1 + (b > 1);
}

unsigned htoi(char *s)
{
  unsigned v;

/*
    for (v = 0;*s;s++)
	v = v*16 + (isdigit(*s) ? (*s - '0') : (islower(*s) ? *s - 'a' + 10 : *s - 'A' + 10));
*/

  if (sscanf(s,"%x",&v) != 1) v = 0;

  return v;
}

char *article(char *m)
{
  if (strchr("aeiouxAEIOUX",*m))
    return "an ";
  else
    return "a ";
}

/*
   Be mean to Miles Bader.
*/
void badermessage(int t,char *m)
{
  if (!baderp) return;

  switch (t) {
  case 1 :
    switch (random() & 63) {
    case 0 :
      message(1,msgLookup("miles.msg1"),article(m),m);
      break;
    case 1 :
      message(1,msgLookup("miles.msg2"),article(m),m);
      break;
    case 2 :
      message(1,msgLookup("miles.msg3"),article(m),m);
      break;
    case 3 :
      message(1,msgLookup("miles.msg4"),article(m),m);
      break;
    case 4 :
      message(1,msgLookup("miles.msg5"),article(m),m);
      break;
    case 5 :
      message(1,msgLookup("miles.msg6"),article(m),m);
      break;
    case 6 :
      message(1,msgLookup("miles.msg7"));
      break;
    case 7 :
      message(1,msgLookup("miles.msg8a"));
      message(1,msgLookup("miles.msg8b"));
      break;
    default :
      break;
    }
    break;
  case 2 :
    break;
  }
}

/*
   In bat mode liven things up a little
*/
void batmessage(int t,char *m)
{
  if (!batp) return;
  
  switch (t) {
  case 1 :
    switch (random() & 63) {
    case 0 :
      message(1,"** BIFF **");
      break;
    case 1 :
      message(1,"** POW **");
      break;
    case 2 :
      message(1,"** CRASH **");
      break;
    case 3 :
      message(1,"** OOOF **");
      break;
    case 4 :
      message(1,"** WHAM **");
      break;
    case 5 :
      message(1,"** CRUNCH **");
      break;
    case 6 :
      message(1,"** BANG **");
      break;
    case 7 :
      message(1,"** SOCK **");
      break;
    default :
      break;
    }
    break;
  case 2 :
    break;
  }
}

void posongate(GWire *w,GCElement *g,int *p,int *n)
{
  int i;
  for (i = 0;i < g->typeinfo->NumPads;i++)
    if ((*n = findwirepos(w,g->wires[i]))) {
      *p = i;
      break;
    }
}

/* Searches an i/o wire list for the number of the target wire */
int findwirepos(GWire *w,GWire *l)
{
  int p;

  if (!l)
    return 0;
  else {
    assert(l != l->next); 
    if (w == l)
      return 1;
    else
      if ((p = findwirepos(w,l->next)) != 0)
	return p + 1;
      else
	return 0;
  }
}

int GetPadPosition(GCElement *g,char *name)
{
  int i;

  for (i = 0;i < g->typeinfo->NumPads;i++)
    if (!strcmp(g->typeinfo->Pad[i].Name,name))
      return i;
  return -1;
}

void undoSignals()
{
#ifdef SIGABRT
  signal(SIGABRT,SIG_DFL);
#endif
  signal(SIGHUP,SIG_DFL);
  signal(SIGQUIT,SIG_DFL);
  signal(SIGILL,SIG_DFL);
  signal(SIGTRAP,SIG_DFL);
  signal(SIGFPE,SIG_DFL);
  signal(SIGBUS,SIG_DFL);
  signal(SIGSEGV,SIG_DFL);
#ifdef SIGEMT
  signal(SIGEMT,SIG_DFL);
#endif
#ifdef SIGSYS
  signal(SIGSYS,SIG_DFL);
#endif
}

void panicSave(int s)
{
  static int in_panic_save = 0;

  if (in_panic_save) {
    printf("**** Signal %d received during panic save.  Sorry...\n",s);
    undoSignals();
    abort();
  }
  in_panic_save = 1;

  if (s) {
    printf("**** Trapped on signal %d\n",s);
  }
  if (baderp) {
    printf("Look what you did *now*, Miles!\n");
    printf("Even though this is your fault, I'll try to save in 'PANIC.v' anyway.");
    VerilogWriteModules("PANIC.v",0);
    printf("Looks like I bailed you out once again Miles.");
  } else if (startrekp) {
    printf("Warp core breach in progress!  All hands abandon ship!\n");
    printf("Launching escape pod 'PANIC.v'.\n");
    VerilogWriteModules("PANIC.v",0);
    printf("Escape pod is away.\n");
  } else {
    printf("Attempting to save circuit in file 'PANIC.v'.\n");
    VerilogWriteModules("PANIC.v",0);
    printf("Panic save completed.\n");
  }
  undoSignals();
  abort();
}

/*
 * Open a file in the context of the current circuit.
 * If the first character of 'name' is '/', then the
 * file is opened "as is".  Otherwise the following
 * path is searched:
 *
 *    current directory
 *    same direcory as current file
 *    user's home directory (value of HOME)
 */
FILE *openInPath(char *name)
{
  char buf[STRMAX];
  FILE *f;
  char *r;

  if (*name == '/') return fopen(name,"r");

  if ((r = Tcl_GetVar(XGate.tcl,"tkg_currentFile",TCL_GLOBAL_ONLY))) {
    strcpy(buf,r);
    if ((r = strrchr(buf,'/'))) {
      if (r != buf) {
	strcpy(r+1,name);
	if ((f = fopen(buf,"r"))) return f;
      }
    }
  }

  if ((r = getenv("HOME"))) {
    strcpy(buf,r);
    strcat(buf,"/");
    strcat(buf,name);
    if ((f = fopen(buf,"r"))) return f;
  }

  return 0;
}

int badaddr(void *S)
{
  return ((unsigned)S & 0x1) != 0;
}

void PickInterval(int *R,int *I)
{
  int p,k,d;

  k = *R/10;
  d = 1;
  for (p = 0;k > 10;p++) {
    d *= 10;
    k /= 10;
  }
  *I = k * d;
}

/*
 * Lookup a message from the appropriate locality file.
 */
char *msgLookup(char *tag)
{
  char *s = (char*) SHash_find(message_table,tag);

  if (!s) {
    char buf[1024];
    sprintf(buf,"<no-msg: %s>",tag);
    s = strdup(buf);
    SHash_insert(message_table,tag,s);
  }

  return s;
}

void strreplace(char *s,char *old_str,char *new_str,int gbl)
{
  char *b = s;
  int ol = strlen(old_str);
  int nl = strlen(new_str);
  int sl = strlen(s);

  for (;*s;s++) {
    if ( (sl-(s-b)) < ol) break;		/* Not enough chars left */

    if (strncmp(s,old_str,ol) == 0) {
      memmove(s+nl,s+ol,(sl-(s-b)));
      memmove(s,new_str,nl);
      s += nl;
      sl += nl-ol;
      if (!gbl) return;
    }
  }
  b[sl] = 0;
}

