/****************************************************************************
    Copyright (C) 1987-2001 by Jeffery P. Hansen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Last edit by hansen on Thu Jun 22 21:07:02 2000
****************************************************************************/
#include "tkgate.h"

#define AND_IN 0
#define AND_OUT 1

static iconDimensions and_iconDims[] = {
  {0, 0, 20, 15, 10, 7},
  {21, 0, 15, 20, 7, 9},
  {16, 21, 20, 15, 9, 7},
  {0, 16, 15, 20, 7, 10},
};
static int and_iconBoldOffset = 37;

struct locate and_out_loc[] ={		/* Gate output */
 {10,0,10,0,D_RIGHT},
 {0,-10,0,-10,D_UP},
 {-10,0,-10,0,D_LEFT},
 {0,10,0,10,D_DOWN}};

struct locate and_in_loc[] = {		/* Gate input */
 {-11,-7,-11,7,D_LEFT},
 {-7,11,7,11,D_DOWN},
 {11,-7,11,7,D_RIGHT},
 {-7,-11,7,-11,D_UP}};

static char *psAnd[] = {
  "%",
  "% An AND gate",
  "%",
  "/psand {",
  "  startgate",
  "  2.5 7 moveto",
  "  -10.5 7 lineto",
  "  -10.5 -7 lineto",
  "  2.5 -7 lineto",
  "  2.5 0 7 -90 90 arc",
  "  closepath",
  "  stroke",
  "  grestore",
  "} bind def",
  0
};

GGateInfo gate_and_info = {
  0,
  "AND",
  "and:nand",0x2,
  "psand",psAnd,

  {{"a",	{"gmgate",0},		{"gmand",0,0,100},	"gat_make and"},
   {"A",	{"gmgate",0},		{"gmnand",3,0,101},	"gat_make and -invert Z"},
   {"Ctl-r a",	{"gmredgate",0},	{"gmrand",0,0,100},	"gat_make and -pins I=1"},
   {"Ctl-r A",	{"gmredgate",0},	{"gmrnand",3,0,101},	"gat_make and -pins I=1 -invert Z"},
   {0}
  },

  and_iconDims,

  2,{{"I",IN,1,2,and_in_loc,1},{"Z",OUT,1,1,and_out_loc,0}},
  {{0,-12,CT},{12,0,LJ},{0,-12,CT},{12,0,LJ}},
  {1},

  {"I-Z",0},
  
  Generic_Make,
  Generic_Init,
  Generic_Delete,
  Generic_GetExtents,
  Generic_HitDistance,
  Generic_Draw,
  Generic_Move,
  Generic_Replicate,
  Generic_AddInput,
  Err_AddOutput,
  Err_AddInOut,
  Err_ChangePin,
  Nop_SimStateFunc,
  Nop_SimHitFunc,
  Generic_PSWrite,
  Generic_EditProps,
  Generic_VerSave,
};

void init_and()
{
  Pixmap P;

  P = Pixmap_registerFromFile("and","and.b");
  gateinfo_iconInit(&gate_and_info,P,and_iconDims,and_iconBoldOffset);
  RegisterGate(&gate_and_info);
}
