#   Copyright (C) 1987-2001 by Jeffery P. Hansen
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
# Last edit by hansen on Mon Dec 18 11:42:48 2000
#

#
# Bindings can be declared with either the 'newBinding' or 'keyBinding'
# commands.  The usage is identical except that 'newBinding' will
# generate an error if a key sequence has already been bound.
#

######################################################################
#
# Special 'hack' bindings.
#
newBinding <Alt-m>			{ }
newBinding <Alt-t>			{ }

######################################################################
#
# Beginning of built-in bindings
#

if { $tkg_allowDebug } {
  newBinding <Control-d>		{ gat_dumpWires }
  newBinding <F6>			{ tkg_setMode 12 }
}

newBinding <bracketleft>		{ gat_addIn }
newBinding <bracketright>		{ gat_addOut }
newBinding <apostrophe>			{ gat_addInOut }
newBinding <at>				{ gat_changePinDir }

newBinding <F1>				{ tkg_setMode 1 }
newBinding <F2>				{ tkg_setMode 3 }
newBinding <F3>				{ tkg_setMode 0 }
newBinding <F4>				{ tkg_setMode 2 }
newBinding <F5>				{ tkg_setMode 9 }

newBinding <Control-F1>			{ set rot 0 }
newBinding <Control-F2>			{ set rot 90 }
newBinding <Control-F3>			{ set rot 180 }
newBinding <Control-F4>			{ set rot 270 }

newBinding <greater>			{ if { "%W" != ".scope"} { gat_openBox } else { .scope.main.frame.canvas zoom 1 } }
newBinding <less>			{ if { "%W" != ".scope"} { gat_closeBox } else { .scope.main.frame.canvas zoom -1 } }
newBinding <Control-v>			{ gat_replicate }
newBinding <Delete>			{ gat_deleteSelected }
newBinding <E>				{ gat_editProps }

newBinding <p>				{ tkg_errBoxUp }
newBinding <Control-p>			{ tkg_errBoxUp }
newBinding <n>				{ tkg_errBoxDown }
newBinding <Control-n>			{ tkg_errBoxDown }
newBinding <bar>			{ gat_align 0 }
newBinding <minus>			{ gat_align 1 }

newBinding <Control-x><k>		{ tkg_new }
newBinding <Control-x><Control-f>	{ tkg_load }
newBinding <Control-x><Control-l>	{ tkg_loadLibrary }
newBinding <Control-x><Control-s>	{ tkg_saveCurrent }
newBinding <Control-x><Control-w>	{ tkg_save }
newBinding <Control-x><Control-p>	{ tkg_printDlg }
newBinding <Control-x><Control-c>	{ tkg_exit }
newBinding <Control-x><o>		{ tkg_editOptions }
newBinding <Control-x><x>		{ gat_copyToBuf }
newBinding <Control-x><a>		{ gat_selectAll }
newBinding <Control-x><E>		{ tkg_editCircProp }
newBinding <Control-x><f>		{ gat_anchor 1 }
newBinding <Control-x><u>		{ gat_anchor 0 }
newBinding <Control-x><r>		{ tkg_cpathAnal }

newBinding <Control-w>			{ gat_cutToBuf }
newBinding <Control-y>			{ gat_yankFromBuf }
newBinding <Control-f>			{ tkg_findObject }

newBinding <Control-s><b>		{ gat_setMajorMode simulate }
newBinding <Control-s><e>		{ gat_setMajorMode edit }
newBinding <Control-s><g>		{ tkg_simRun }
newBinding <Control-s><s>		{ tkg_simStop }
newBinding <Control-s><k>		{ tkg_editBreakpoints }
newBinding <Control-s><x>		{ tkg_doSimScript }
newBinding <Control-s><l>		{ tkg_simLoadMem }
newBinding <Control-s><d>		{ tkg_simDumpMem }
newBinding <Control-s><p>		{ tkg_scopePrintDlg }
newBinding <space>			{ tkg_simStep }
newBinding <Tab>			{ tkg_simCycle }

newBinding <Control-l>			{ gat_refreshScreen }

newBinding <Control-b>n			{ tkg_blockNew }
newBinding <Control-b>d			{ tkg_blockDelete }
newBinding <Control-b>c			{ tkg_blockCopy }
newBinding <Control-b>r			{ tkg_blockRename }
newBinding <Control-b>s			{ gat_setBlockDesc }
newBinding <Control-b>e			{ gat_editBlockDesc }
newBinding <Control-b>l			{ tkg_blockClaim }

newBinding <Control-z>i			{ gat_zoom 1 }
newBinding <Control-z>o			{ gat_zoom -1 }

newBinding <Left>			{ gat_moveGate -1 0 }
newBinding <Right>			{ gat_moveGate 1 0 }
newBinding <Up>				{ gat_moveGate 0 -1 }
newBinding <Down>			{ gat_moveGate 0 1 }

newBinding <Control-g>			{ endPrefix; tkg_cancel; gat_unselectGates }
newBinding <Meta-KeyPress-U>		{ }
newBinding <Escape>			{ tkg_cancel; gat_unselectGates }

