#   Copyright (C) 1987-2001 by Jeffery P. Hansen
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
# Last edit by hansen on Mon Nov 20 10:29:13 2000
#
#

set solid {#define aa_width 25
#define aa_height 15
static unsigned char aa_bits[] = {
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff};}

set colors {red blue magenta4 cyan4 tan4 green4 black magenta yellow RosyBrown1 white}

#
# Create color images
#
foreach c $colors {
  image create bitmap $c -foreground $c -data $solid
}

set opts_mode 0
set opts_smoothScroll 0
set opts_regionUpdate 0
set opts_siteName ""
set opts_blockMoveStyle 0
set opts_helpBalloons 1
set opts_noviceMode 1
set opts_allowDebug 1
set opts_checkpointEnabled 1
set opts_checkpointFreq 300
set opts_flashCPath 1
set opts_numCPath 10

set opts_instColor           $tkgdef_instColor          
set opts_moduleColor         $tkgdef_moduleColor        
set opts_modulePortColor     $tkgdef_modulePortColor    
set opts_frameColor          $tkgdef_frameColor         
set opts_commentColor        $tkgdef_commentColor       
set opts_hyperlinkColor      $tkgdef_hyperlinkColor       
set opts_wireColor           $tkgdef_wireColor          
set opts_busColor            $tkgdef_busColor           
set opts_toolColor           $tkgdef_toolColor          
set opts_cpathColor          $tkgdef_cpathColor          
set opts_gridColor           $tkgdef_gridColor          
set opts_oneColor            $tkgdef_oneColor           
set opts_zeroColor           $tkgdef_zeroColor          
set opts_floatColor          $tkgdef_floatColor         
set opts_unknownColor        $tkgdef_unknownColor       
set opts_offLedColor         $tkgdef_offLedColor
set opts_onLedColor          $tkgdef_onLedColor 
set opts_zLedColor           $tkgdef_zLedColor  


set sopts_simStepSize $tkg_simStepSize
set sopts_simClockStepSize $tkg_simClockStepSize
set sopts_simClockOverStep $tkg_simClockOverStep
set sopts_allowDebug $tkg_allowDebug
set sopts_simActClock $tkg_simActClock
set sopts_simUseActClock $tkg_simUseActClock
set sopts_simInitScript $tkg_simInitScript
set sopts_simLogFile ""
set sopts_simDelayFile ""
set sopts_simCustomDelay 0

proc tkg_saveOptions {} {
  global tkg_prefFile tkg_enableBeakModes
  global tkg_trekMode tkg_batMode tkg_baderMode tkg_batRate
  global tkg_siteName tkg_regionUpdate tkg_smoothScroll
  global tkg_allowDebug tkg_blockMoveStyle tkg_helpBalloons tkg_noviceMode
  global tkg_printCommand tkg_printPgSize tkg_printPgSizeA4 tkg_printPgOrient
  global tkg_printDuplex tkg_printStyle tkg_printIndex tkg_printGraph
  global tkg_checkpointFreq tkg_checkpointEnabled
  global tkg_simStepSize tkg_simClockStepSize tkg_simClockOverStep
  global tkg_simActClock tkg_simUseActClock tkg_simDebugInterface
  global tkg_simInitScript tkg_simCustomDelay tkg_simDelayFile

  global tkg_instColor tkg_moduleColor tkg_modulePortColor tkg_frameColor 
  global tkg_commentColor tkg_hyperlinkColor tkg_wireColor tkg_busColor tkg_toolColor
  global tkg_gridColor tkg_oneColor tkg_zeroColor tkg_floatColor tkg_cpathColor 
  global tkg_unknownColor tkg_offLedColor tkg_onLedColor tkg_zLedColor  
  global tkg_checkVersion tkg_flashCPath tkg_numCPath


  set fd [open $tkg_prefFile w]
  puts $fd "#"
  puts $fd "# Automatically generated preferences file - DO NOT EDIT"
  puts $fd "#"
  puts $fd ""

  puts $fd "#"
  puts $fd "# Basic settings"
  puts $fd "#"
  puts $fd "set tkg_siteName \"$tkg_siteName\""
  puts $fd "set tkg_smoothScroll $tkg_smoothScroll"
  puts $fd "set tkg_regionUpdate $tkg_regionUpdate"
  puts $fd "set tkg_blockMoveStyle $tkg_blockMoveStyle"
  puts $fd "set tkg_helpBalloons $tkg_helpBalloons"
  puts $fd "set tkg_noviceMode $tkg_noviceMode"
  puts $fd ""
   
  puts $fd "#"
  puts $fd "# Mode settings"
  puts $fd "#"
  puts $fd "set tkg_enableBeakModes $tkg_enableBeakModes"
  puts $fd "set tkg_baderMode $tkg_baderMode"
  puts $fd "set tkg_batMode $tkg_batMode"
  puts $fd "set tkg_trekMode $tkg_trekMode"
  puts $fd "set tkg_batRate $tkg_batRate"
  puts $fd "set tkg_allowDebug $tkg_allowDebug"
  puts $fd ""


  puts $fd "#"
  puts $fd "# Simulator settings"
  puts $fd "#"
  puts $fd "set tkg_simStepSize $tkg_simStepSize"
  puts $fd "set tkg_simClockStepSize $tkg_simClockStepSize"
  puts $fd "set tkg_simClockOverStep $tkg_simClockOverStep"
  puts $fd "set tkg_simDebugInterface $tkg_simDebugInterface"
  puts $fd "set tkg_simActClock \"$tkg_simActClock\""
  puts $fd "set tkg_simUseActClock $tkg_simUseActClock"
  puts $fd "set tkg_simInitScript \"$tkg_simInitScript\""
  puts $fd "set tkg_simCustomDelay $tkg_simCustomDelay"
  puts $fd "set tkg_simDelayFile [list $tkg_simDelayFile]"
  puts $fd ""

  puts $fd "#"
  puts $fd "# Circuit Anlysis"
  puts $fd "#"
  puts $fd "set tkg_flashCPath $tkg_flashCPath"
  puts $fd "set tkg_numCPath $tkg_numCPath"
  puts $fd ""

  puts $fd "#"
  puts $fd "# Colors"
  puts $fd "#"
  puts $fd "set tkg_instColor           \"$tkg_instColor\""
  puts $fd "set tkg_moduleColor         \"$tkg_moduleColor\""        
  puts $fd "set tkg_modulePortColor     \"$tkg_modulePortColor\""    
  puts $fd "set tkg_frameColor          \"$tkg_frameColor\""         
  puts $fd "set tkg_commentColor        \"$tkg_commentColor\""       
  puts $fd "set tkg_hyperlinkColor      \"$tkg_hyperlinkColor\""       
  puts $fd "set tkg_wireColor           \"$tkg_wireColor\""          
  puts $fd "set tkg_busColor            \"$tkg_busColor\""           
  puts $fd "set tkg_toolColor           \"$tkg_toolColor\""          
  puts $fd "set tkg_cpathColor          \"$tkg_cpathColor\""          
  puts $fd "set tkg_gridColor           \"$tkg_gridColor\""          
  puts $fd "set tkg_oneColor            \"$tkg_oneColor\""           
  puts $fd "set tkg_zeroColor           \"$tkg_zeroColor\""          
  puts $fd "set tkg_floatColor          \"$tkg_floatColor\""         
  puts $fd "set tkg_unknownColor        \"$tkg_unknownColor\""       
  puts $fd "set tkg_offLedColor         \"$tkg_offLedColor\""       
  puts $fd "set tkg_onLedColor          \"$tkg_onLedColor\""       
  puts $fd "set tkg_zLedColor           \"$tkg_zLedColor\""       

  puts $fd ""

  puts $fd "#"
  puts $fd "# Pinter settings"
  puts $fd "#"
  puts $fd "set tkg_printCommand \"$tkg_printCommand\""
  puts $fd "set tkg_printPgSizeA4 $tkg_printPgSizeA4"
  puts $fd "set tkg_printPgSize $tkg_printPgSize"
  puts $fd "set tkg_printPgOrient $tkg_printPgOrient"
  puts $fd "set tkg_printDuplex $tkg_printDuplex"
  puts $fd "set tkg_printStyle $tkg_printStyle"
  puts $fd "set tkg_printIndex $tkg_printIndex"
  puts $fd "set tkg_printGraph $tkg_printGraph"
  puts $fd ""

  puts $fd "#"
  puts $fd "# Checkpointing"
  puts $fd "#"
  puts $fd "set tkg_checkpointEnabled $tkg_checkpointEnabled"
  puts $fd "set tkg_checkpointFreq $tkg_checkpointFreq"
  puts $fd ""


  puts $fd "#"
  puts $fd "# Other Options"
  puts $fd "#"
  puts $fd "set tkg_checkVersion $tkg_checkVersion"
  puts $fd ""

  close $fd
}

proc tkg_optsGet {} {
  global opts_mode tkg_trekMode tkg_batMode tkg_baderMode lang

  copyVar opts_siteName tkg_siteName
  copyVar opts_regionUpdate tkg_regionUpdate
  copyVar opts_smoothScroll tkg_smoothScroll
  copyVar opts_blockMoveStyle tkg_blockMoveStyle
  copyVar opts_helpBalloons tkg_helpBalloons
  copyVar opts_noviceMode tkg_noviceMode
  copyVar opts_allowDebug tkg_allowDebug
  copyVar opts_checkpointEnabled tkg_checkpointEnabled
  copyVar opts_checkpointFreq tkg_checkpointFreq

  copyVar opts_instColor           tkg_instColor          
  copyVar opts_moduleColor         tkg_moduleColor        
  copyVar opts_modulePortColor     tkg_modulePortColor    
  copyVar opts_frameColor          tkg_frameColor         
  copyVar opts_commentColor        tkg_commentColor       
  copyVar opts_hyperlinkColor      tkg_hyperlinkColor       
  copyVar opts_wireColor           tkg_wireColor          
  copyVar opts_busColor            tkg_busColor           
  copyVar opts_toolColor           tkg_toolColor          
  copyVar opts_cpathColor          tkg_cpathColor          
  copyVar opts_gridColor           tkg_gridColor          
  copyVar opts_oneColor            tkg_oneColor           
  copyVar opts_zeroColor           tkg_zeroColor          
  copyVar opts_floatColor          tkg_floatColor         
  copyVar opts_unknownColor        tkg_unknownColor       
  copyVar opts_offLedColor         tkg_offLedColor
  copyVar opts_onLedColor          tkg_onLedColor
  copyVar opts_zLedColor           tkg_zLedColor

  copyVar opts_checkVersion        tkg_checkVersion

  copyVar opts_flashCPath          tkg_flashCPath
  copyVar opts_numCPath            tkg_numCPath

  copyVar sopts_simStepSize tkg_simStepSize
  copyVar sopts_simClockStepSize tkg_simClockStepSize
  copyVar sopts_simClockOverStep tkg_simClockOverStep
  copyVar sopts_simDebugInterface tkg_simDebugInterface
  copyVar sopts_simActClock tkg_simActClock
  copyVar sopts_simUseActClock tkg_simUseActClock
  copyVar sopts_simInitScript tkg_simInitScript
  copyVar sopts_simCustomDelay tkg_simCustomDelay
  copyVar sopts_simDelayFile tkg_simDelayFile

  copyVar pd_print tkg_printCommand

  if { $lang == "en" } {
    copyVar pd_paper tkg_printPgSize
  } else {
    copyVar pd_paper tkg_printPgSizeA4
  }

  copyVar pd_orient tkg_printPgOrient
  copyVar pd_duplexMode tkg_printDuplex
  copyVar pd_style tkg_printStyle
  copyVar pd_index tkg_printIndex
  copyVar pd_graph tkg_printGraph

  if { $tkg_baderMode != 0 } {
    set opts_mode 3
  } elseif { $tkg_trekMode != 0 } {
    set opts_mode 2
  } elseif { $tkg_batMode != 0 } {
    set opts_mode 1
  } else {
    set opts_mode 0
  }
}

proc tkg_optsStore {} {
  global opts_mode opts_siteName lang
  global tkg_trekMode tkg_batMode tkg_baderMode tkg_batRate
  global tkg_siteName 

  set tkg_siteName [tr-d [string trim $opts_siteName " \t"] "\""]
  copyVar tkg_regionUpdate opts_regionUpdate
  copyVar tkg_smoothScroll opts_smoothScroll
  copyVar tkg_blockMoveStyle opts_blockMoveStyle
  copyVar tkg_helpBalloons opts_helpBalloons
  copyVar tkg_noviceMode opts_noviceMode
  copyVar tkg_allowDebug opts_allowDebug
  copyVar tkg_checkpointEnabled opts_checkpointEnabled
  checkCopyVar tkg_checkpointFreq opts_checkpointFreq 1 9999

  copyVar tkg_flashCPath          opts_flashCPath
  copyVar tkg_numCPath            opts_numCPath

  checkCopyVar tkg_simStepSize sopts_simStepSize		1 1000000
  checkCopyVar tkg_simClockStepSize sopts_simClockStepSize	1 1000000
  checkCopyVar tkg_simClockOverStep sopts_simClockOverStep	0 1000000
  copyVar tkg_simDebugInterface sopts_simDebugInterface	
  copyVar tkg_simActClock sopts_simActClock
  copyVar tkg_simUseActClock sopts_simUseActClock
  copyVar tkg_simInitScript sopts_simInitScript
  copyVar tkg_simCustomDelay sopts_simCustomDelay
  copyVar tkg_simDelayFile sopts_simDelayFile

  copyVar tkg_instColor          opts_instColor           
  copyVar tkg_moduleColor        opts_moduleColor         
  copyVar tkg_modulePortColor    opts_modulePortColor     
  copyVar tkg_frameColor         opts_frameColor          
  copyVar tkg_commentColor       opts_commentColor          
  copyVar tkg_hyperlinkColor     opts_hyperlinkColor        
  copyVar tkg_wireColor          opts_wireColor           
  copyVar tkg_busColor           opts_busColor            
  copyVar tkg_toolColor          opts_toolColor           
  copyVar tkg_cpathColor         opts_cpathColor           
  copyVar tkg_gridColor          opts_gridColor           
  copyVar tkg_oneColor           opts_oneColor            
  copyVar tkg_zeroColor          opts_zeroColor           
  copyVar tkg_floatColor         opts_floatColor          
  copyVar tkg_unknownColor       opts_unknownColor        
  copyVar tkg_offLedColor        opts_offLedColor
  copyVar tkg_onLedColor         opts_onLedColor
  copyVar tkg_zLedColor          opts_zLedColor

  copyVar tkg_checkVersion       opts_checkVersion

  copyVar tkg_printCommand pd_print

  if { $lang == "en" } {
    copyVar tkg_printPgSize pd_paper
  } else {
    copyVar tkg_printPgSizeA4 pd_paper
  }
  copyVar tkg_printPgOrient pd_orient
  copyVar tkg_printDuplex pd_duplexMode
  copyVar tkg_printStyle pd_style
  copyVar tkg_printIndex pd_index
  copyVar tkg_printGraph pd_graph

  set tkg_trekMode 0
  set tkg_batMode 0
  set tkg_baderMode 0
  switch $opts_mode {
    1 { set tkg_batMode 1; after $tkg_batRate gat_batInc }
    2 { set tkg_trekMode 1 }
    3 { set tkg_baderMode 1 }
    default { }
  }

  gat_reinitDelay
  gat_setcolors
  tkg_saveOptions
}

proc tkg_eoBasic {w} {
  frame $w -relief groove -bd 2

  label $w.siteL -text "[m opt.site]:" -anchor w
  entry $w.siteE -width 30 -textvariable opts_siteName

  pack $w.siteL -padx 5 -pady 5 -side left
  pack $w.siteE -padx 5 -pady 5 -fill x -expand 1

  helpon $w.siteL [m ho.opt.site]
}

proc setColor {w c vname} {
  global $vname

  set $vname $c
  $w configure -image $c
}

proc colorselector {w vname} {
  global colors $vname

  set c [set $vname]

  menubutton $w -image $c -bd 2 -relief raised -menu $w.menu -indicatoron 1

  menu $w.menu -tearoff 0
  foreach c $colors {
#    $w.menu add command -image $c -command "setColor $w $c $vname"
    $w.menu add radiobutton -image $c -value $c -variable $vname -command "setColor $w $c $vname"
  }

}

proc colorDefaults {w} {
  global opts_instColor opts_moduleColor opts_modulePortColor opts_frameColor 
  global opts_commentColor opts_hyperlinkColor opts_wireColor opts_busColor opts_toolColor 
  global opts_gridColor opts_oneColor opts_zeroColor opts_floatColor  opts_cpathColor 
  global opts_unknownColor opts_offLedColor opts_onLedColor opts_zLedColor 

  copyVar opts_instColor           tkgdef_instColor          
  copyVar opts_moduleColor         tkgdef_moduleColor        
  copyVar opts_modulePortColor     tkgdef_modulePortColor    
  copyVar opts_frameColor          tkgdef_frameColor         
  copyVar opts_commentColor        tkgdef_commentColor       
  copyVar opts_hyperlinkColor      tkgdef_hyperlinkColor       
  copyVar opts_wireColor           tkgdef_wireColor          
  copyVar opts_busColor            tkgdef_busColor           
  copyVar opts_toolColor           tkgdef_toolColor          
  copyVar opts_cpathColor          tkgdef_cpathColor          
  copyVar opts_gridColor           tkgdef_gridColor          
  copyVar opts_oneColor            tkgdef_oneColor           
  copyVar opts_zeroColor           tkgdef_zeroColor          
  copyVar opts_floatColor          tkgdef_floatColor         
  copyVar opts_unknownColor        tkgdef_unknownColor       
  copyVar opts_offLedColor         tkgdef_offLedColor
  copyVar opts_onLedColor          tkgdef_onLedColor
  copyVar opts_zLedColor           tkgdef_zLedColor

  $w.instc    configure -image $opts_instColor
  $w.modc     configure -image $opts_moduleColor
  $w.modpc    configure -image $opts_modulePortColor
  $w.framec   configure -image $opts_frameColor
  $w.commc    configure -image $opts_commentColor
  $w.hlinkc   configure -image $opts_hyperlinkColor
  $w.wirec    configure -image $opts_wireColor
  $w.busc     configure -image $opts_busColor
  $w.toolc    configure -image $opts_toolColor
  $w.cpathc   configure -image $opts_cpathColor
  $w.gridc    configure -image $opts_gridColor
  $w.onec     configure -image $opts_oneColor
  $w.zeroc    configure -image $opts_zeroColor
  $w.floatc   configure -image $opts_floatColor
  $w.unknownc configure -image $opts_unknownColor
  $w.offledc  configure -image $opts_offLedColor
  $w.onledc   configure -image $opts_onLedColor
  $w.zledc    configure -image $opts_zLedColor
}

proc tkg_eoColors {w} {
  frame $w

  frame $w.c

  label $w.c.inst -text [m opt.inst]
  colorselector $w.c.instc opts_instColor

  label $w.c.mod -text [m opt.mods]
  colorselector $w.c.modc opts_moduleColor

  label $w.c.modp -text [m opt.modports]
  colorselector $w.c.modpc opts_modulePortColor

  label $w.c.frame -text [m opt.frames]
  colorselector $w.c.framec opts_frameColor

  label $w.c.comm -text [m opt.comment]
  colorselector $w.c.commc opts_commentColor

  label $w.c.hlink -text [m opt.hlink]
  colorselector $w.c.hlinkc opts_hyperlinkColor

  label $w.c.wire -text [m opt.wire]
  colorselector $w.c.wirec opts_wireColor

  label $w.c.bus -text [m opt.bus]
  colorselector $w.c.busc opts_busColor

  label $w.c.tool -text [m opt.tools]
  colorselector $w.c.toolc opts_toolColor

  label $w.c.cpath -text [m opt.cpath]
  colorselector $w.c.cpathc opts_cpathColor

  label $w.c.grid -text [m opt.grid]
  colorselector $w.c.gridc opts_gridColor

  label $w.c.one -text [m opt.logic1]
  colorselector $w.c.onec opts_oneColor

  label $w.c.zero -text [m opt.logic0]
  colorselector $w.c.zeroc opts_zeroColor

  label $w.c.float -text [m opt.float]
  colorselector $w.c.floatc opts_floatColor

  label $w.c.unknown -text [m opt.unknown]
  colorselector $w.c.unknownc opts_unknownColor

  label $w.c.offled -text [m opt.offled]
  colorselector $w.c.offledc opts_offLedColor

  label $w.c.onled -text [m opt.onled]
  colorselector $w.c.onledc opts_onLedColor

  label $w.c.zled -text [m opt.zled]
  colorselector $w.c.zledc opts_zLedColor

  set colorItem { inst mod modp frame comm hlink wire bus tool cpath grid one zero float unknown offled onled zled }
  set r 0
  set c 0

  foreach ci $colorItem {
    grid $w.c.$ci     -row $r  -column $c -padx 5 -pady 3 -sticky w
    grid $w.c.${ci}c     -row $r  -column [expr $c+1] -padx 5 -pady 3 -sticky w

    if { $c == 0 } {
      set c 3
    } else {
      set c 0
      incr r
    }
  }

  grid columnconfigure $w.c 2 -minsize 30

  pack $w.c -anchor w -padx 5 -pady 5

  frame $w.pad
  pack $w.pad -fill both -expand 1
  
  button $w.def -text [m opt.restdef] -command "colorDefaults $w.c"
  pack $w.def -anchor sw -padx 5 -pady 5
}

proc tkg_eoDisplay {w} {
  frame $w -relief groove -bd 2
  frame $w.f
  checkbutton $w.f.ss -variable opts_smoothScroll -text [m opt.smoothscroll]
  checkbutton $w.f.ru -variable opts_regionUpdate -text [m opt.regudate]
  checkbutton $w.f.om -variable opts_blockMoveStyle -text [m opt.outmove]
  checkbutton $w.f.hb -variable opts_helpBalloons -text [m opt.balloon]
  checkbutton $w.f.db -variable opts_allowDebug -text [m opt.debug]
  checkbutton $w.f.nv -variable opts_noviceMode -text [m opt.novice]
  frame $w.f.cpe

  checkbutton $w.f.cpe.b -variable opts_checkpointEnabled -text [m opt.ckpoint]
  label $w.f.cpe.l -text "   [m opt.freq]:"
  entry $w.f.cpe.e -textvariable opts_checkpointFreq -width 4
  pack $w.f.cpe.b $w.f.cpe.l $w.f.cpe.e -side left

  pack $w.f.ss -anchor w
  pack $w.f.ru -anchor w
  pack $w.f.om -anchor w
  pack $w.f.hb -anchor w
  pack $w.f.db -anchor w
  pack $w.f.nv -anchor w
  pack $w.f.cpe -anchor w
  pack $w.f -padx 10 -pady 10 -anchor w

  helpon $w.f.ss [m ho.opt.smooth]
  helpon $w.f.ru [m ho.opt.clip]
  helpon $w.f.om [m ho.opt.outmove]
  helpon $w.f.hb [m ho.opt.bhelp]
  helpon $w.f.nv [m ho.opt.novice]
  helpon $w.f.db [m ho.opt.debug]
  helpon $w.f.cpe.b [m ho.opt.ckpt]
  helpon $w.f.cpe.l [m ho.opt.ckptfreq]

}

proc tkg_eoModes {w} {
    frame $w -relief groove -bd 2
  checkbutton $w.enable -text [m opt.beak] -variable tkg_enableBeakModes
    frame $w.f
  label $w.f.lab -text [m opt.mode]:
  radiobutton $w.f.normal -text [m opt.normal] -variable opts_mode -value 0
  radiobutton $w.f.bat -text [m opt.bat] -variable opts_mode -value 1
  radiobutton $w.f.trek -text [m opt.trek] -variable opts_mode -value 2
  radiobutton $w.f.miles -text [m opt.miles] -variable opts_mode -value 3

    grid $w.f.lab -row 0 -column 0 -sticky e
    grid $w.f.normal -row 0 -column 1 -sticky w
    grid $w.f.bat -row 1 -column 1 -sticky w
    grid $w.f.trek -row 2 -column 1 -sticky w
    grid $w.f.miles -row 3 -column 1 -sticky w

    pack $w.enable -padx 5 -pady 5 -anchor w
    pack $w.f -padx 5 -pady 5 -anchor w

  helpon $w.enable [m ho.opt.beak]
  helpon $w.f.miles [m ho.opt.miles]
  helpon $w.f.bat [m ho.opt.bat]
  helpon $w.f.trek [m ho.opt.trek]
  helpon $w.f.normal [m ho.opt.normal]
}

#############################################################################
#
# simulator options
#

proc tkg_eoDebugOpts {w} {
  frame $w -relief groove -bd 2

  checkbutton $w.dbg -variable sopts_simDebugInterface -text [m opt.showsimcmd] -anchor w

  frame $w.i
  label $w.i.logl -text "[m opt.logfile]:" -anchor w
  entry $w.i.loge -width 40 -textvariable sopts_simLogFile

  pack $w.dbg  -padx 5 -pady 5 -fill x -anchor w

  pack $w.i -padx 5 -pady 5 -anchor w -fill x
  pack $w.i.logl -anchor w
  pack $w.i.loge -anchor w -fill x

  helpon $w.dbg [m ho.simwatch]
  helpon $w.i.logl [m ho.simlog]
}

proc tkg_eoSimBaseOpts {w} {
  global simscr_w

  frame $w -relief groove -bd 2

  frame $w.t

  label $w.t.simstepL -text "[m opt.estepsz]:"
  entry $w.t.simstepE -width 5 -textvariable sopts_simStepSize

  label $w.t.clkstepL -text "[m opt.cstepsz]:"
  entry $w.t.clkstepE -width 5 -textvariable sopts_simClockStepSize

  label $w.t.clkostepL -text "[m opt.overstep]:"
  entry $w.t.clkostepE -width 5 -textvariable sopts_simClockOverStep

  frame $w.i
  label $w.i.initL -text "[m opt.initscript]:"
  entry $w.i.initE -width 40 -textvariable sopts_simInitScript
  set simscr_w $w.i.initE

  button $w.i.browse -text [m b.browse]  -command {
    set file [tk_getOpenFile -defaultextension $simScript_filter -filetypes $simScript_filetypes -parent $simscr_w]
    if { $file != "" } { 
      set sopts_simInitScript $file
      $simscr_w  icursor end
      $simscr_w  xview end
    }
  }

  grid $w.t.simstepL -row 0 -column 0 -sticky e -padx 3 -pady 5
  grid $w.t.simstepE -row 0 -column 1 -sticky w -padx 3 -pady 5
  grid $w.t.clkstepL -row 1 -column 0 -sticky e -padx 3 -pady 5
  grid $w.t.clkstepE -row 1 -column 1 -sticky w -padx 3 -pady 5 
  grid $w.t.clkostepL -row 2 -column 0 -sticky e -padx 3 -pady 5
  grid $w.t.clkostepE -row 2 -column 1 -sticky w -padx 3 -pady 5 

  pack $w.t -anchor w
  pack $w.i -padx 5 -pady 5 -fill x -expand 1
  pack $w.i.initL -anchor w
  pack $w.i.browse -anchor w -fill x -padx 5 -pady 3 -side right
  pack $w.i.initE -anchor w -fill x -expand 1

  helpon $w.t.simstepL [m ho.opt.simstep]
  helpon $w.t.clkstepL [m ho.opt.ckstep]
  helpon $w.t.clkostepL [m ho.opt.ckover]
  helpon $w.i.initL [m ho.opt.init]
}

proc tkg_eoSimClock {w} {
  global sopts_simUseActClock
  frame $w -relief groove -bd 2

  radiobutton $w.all -text [m opt.posedge] -variable sopts_simUseActClock -value 0 -command "$w.actNam configure -state disabled -foreground gray"
  radiobutton $w.act -text "[m opt.setclock]:" -variable sopts_simUseActClock -value 1 -command "$w.actNam configure -state normal -foreground black"
  entry $w.actNam -width 15 -textvariable sopts_simActClock

  if { $sopts_simUseActClock == 0 } {
    $w.actNam configure -state disabled
  }

  helpon $w.all [m ho.opt.ckall]
  helpon $w.act [m ho.opt.ckspec]

  pack $w.all -padx 5 -pady 5 -anchor w
  pack $w.act -side left -padx 5 -pady 5 -anchor w 
  pack $w.actNam -side left -padx 5 -pady 5 -anchor w -fill x -expand 1
}

proc addDelayFile {w} {
  global gdf_filter gdf_filetypes sopts_simDelayFile

  set filename [tk_getOpenFile -defaultextension $gdf_filter -filetypes $gdf_filetypes -parent $w]
  if {$filename != "" } {
    $w.dirs.lb insert end $filename
  }

  set sopts_simDelayFile [$w.dirs.lb get 0 end]
}

proc delDelayFile {w} {
  global gdf_filter gdf_filetypes sopts_simDelayFile

  set idx [$w.dirs.lb curselection]
  if { $idx != "" } {
    catch { $w.dirs.lb delete $idx }
  }

  set sopts_simDelayFile [$w.dirs.lb get 0 end]
}

proc tkg_eoSimDelay {w} {
  global sopts_simDelayFile

  frame $w -relief groove -bd 2

  label $w.l -text [m opt.delayfilepath]

  frame $w.dirs
  listbox $w.dirs.lb -height 3 -xscrollcommand "$w.dirs.hb set" -yscrollcommand "$w.dirs.vb set"
  scrollbar $w.dirs.vb -orient vertical -command "$w.dirs.lb yview"
  scrollbar $w.dirs.hb -orient horizontal  -command "$w.dirs.lb xview"

  grid rowconfigure $w.dirs 0 -weight 1
  grid columnconfigure $w.dirs 0 -weight 1
  grid  $w.dirs.lb -row 0 -column 0 -sticky nsew
  grid  $w.dirs.vb -row 0 -column 1 -sticky ns
  grid  $w.dirs.hb -row 1 -column 0 -sticky ew

  button $w.add -text [m b.add] -command "addDelayFile $w"
  button $w.del -text [m b.delete] -command "delDelayFile $w"

  pack  $w.l -padx 5 -pady 3 -anchor w
  pack  $w.dirs -padx 5 -pady 3 -side left -expand 1 -fill x
  pack $w.add -padx 5 -pady 3 -fill x
  pack $w.del -padx 5 -pady 3 -fill x

  foreach f $sopts_simDelayFile {
    $w.dirs.lb insert end $f
  }

#  checkbutton $w.l -text [m opt.delayfile] -anchor w -variable sopts_simCustomDelay
#  entry $w.e -textvariable sopts_simDelayFile
#  pack $w.l $w.e -padx 5 -pady 3 -fill both -anchor w
}

proc tkg_eoOther {w} {
  frame $w -relief groove -bd 2
  checkbutton $w.l -text [m opt.vercheck] -anchor w -variable opts_checkVersionn -justify left
  pack $w.l -padx 5 -pady 3 -fill both -anchor w
}

proc tkg_eoAnalysis {w} {
  global opts_numCPath tkg_cpathListLengths

  frame $w -relief groove -bd 2

  label $w.cp -text [m opt.cpopts]
  checkbutton $w.flash -text [m opt.cpflash] -variable opts_flashCPath

  frame $w.num
  label $w.num.l -text [m opt.maxpath]
  menubutton $w.num.v -text $opts_numCPath -indicatoron 1 -relief raised -bd 2 -menu $w.num.v.m -width 3
  menu $w.num.v.m -tearoff 0
  set path_maxes $tkg_cpathListLengths
  foreach n $path_maxes {
    $w.num.v.m add command -label $n -command "$w.num.v configure -text $n; set opts_numCPath $n"
  }
  pack $w.num.l  $w.num.v -side left

  pack $w.cp -padx 5 -pady 3 -anchor w
  pack $w.flash -padx 20 -pady 3 -anchor w
  pack $w.num -padx 20 -pady 3 -anchor w
}

proc tkg_editOptions {} {
  global tkg_allowDebug

  tkg_optsGet

  set w .opts
  if { [catch {toplevel $w}] } { return }

  wm resizable $w 0 0
  wm title $w "TkGate: Options"
  wm geometry $w [offsetgeometry . 50 50]

  frame $w.t -relief raised -bd 2

  set tabs {General Print Analysis Simulator Colors}
  set labels [list [m opt.general] [m opt.print] [m opt.analysis] [m opt.simulate] [m opt.color]]

  if { $tkg_allowDebug } {
    lappend tabs Debug
    lappend labels [m debug]
  }

  tabbox $w.t.tab -width 600 -height 450 -tabwidth 95 -tabs $tabs -command options_tab -tablabels $labels

  pack $w.t.tab -padx 5 -pady 5

  okcancel $w.b { tkg_optsStore; destroy .opts } { destroy .opts }
  
  pack $w.t $w.b -fill both

  bind $w <Return> { tkg_optsStore; destroy .opts }
}

proc options_tab {w tab} {
  global tkg_enableBeakModes

  switch $tab {
    General {
      frame $w
      tkg_eoBasic $w.b
      tkg_eoDisplay $w.d
      pack  $w.b $w.d -padx 5 -pady 5 -fill both -anchor w

      if { $tkg_enableBeakModes } {
	tkg_eoModes $w.bm
	pack $w.bm -fill both -padx 5 -pady 5
      }
    }
    Print {
      frame		$w

      tkg_prntLprSel $w.lpr groove
      tkg_prntPaperSel $w.pap groove
      tkg_prntStyleSel $w.sty groove
      pack $w.lpr -fill x -pady 3 -padx 5
      pack $w.pap -fill x -pady 3 -padx 5
      pack $w.sty -fill x -pady 3 -padx 5

    }
    Analysis {
      frame $w
      tkg_eoAnalysis $w.analy
      pack $w.analy -fill x  -padx 5 -pady 3
    }
    Simulator {
      frame		$w

      tkg_eoSimBaseOpts $w.base
      pack $w.base -fill x -padx 5 -pady 3 -expand 1

      tkg_eoSimClock $w.clock
      pack $w.clock -fill x  -padx 5 -pady 3 -expand 1

      tkg_eoSimDelay $w.delay
      pack $w.delay -fill x  -padx 5 -pady 3
    }
    Colors {
      tkg_eoColors $w
    }
    Debug {
      frame $w
      tkg_eoDebugOpts $w.opts
      pack $w.opts -fill x  -padx 5 -pady 3
    }
  }
}

