#   Copyright (C) 1987-2001 by Jeffery P. Hansen
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
# Last edit by hansen on Mon Dec 18 14:24:25 2000

proc ul {n} {
  global lang

  if { $lang == "en" } {
      return $n
  } else {
      return -1
  }
}

#
# File menu
#
proc tkg_makeFileMenu {m} {
    menu $m
    $m add command -label [m new] -underline [ul 0] -command tkg_new -accelerator "Ctl-X k"
    $m add command -label [m open] -underline [ul 0] -command tkg_load -accelerator "Ctl-X Ctl-F"
    $m add command -label [m openlib] -underline [ul 5] -command tkg_loadLibrary -accelerator "Ctl-X Ctl-L"
    $m add command -label [m save] -underline [ul 0] -command tkg_saveCurrent -accelerator "Ctl-X Ctl-S"
    $m add command -label [m saveas] -underline [ul 1] -command tkg_save -accelerator "Ctl-X Ctl-W"
    $m add separator
    $m add command -label [m print] -underline [ul 0] -accelerator "Ctl-X Ctl-P" -command tkg_printDlg
    $m add command -label [m options] -underline [ul 2] -command tkg_editOptions -accelerator "Ctl-X o"
    $m add separator
    $m add command -label [m quit]  -underline [ul 0] -command { tkg_exit } -accelerator "Ctl-X Ctl-C"
}

######################################################################
#
# Edit menu
#
proc tkg_makeEditMenu {m} {
    menu $m
    $m add command -label [m cut] -underline [ul 0] -accelerator "Ctl-W" -command gat_cutToBuf
    $m add command -label [m copy] -underline [ul 3] -accelerator "Ctl-X x" -command gat_copyToBuf
    $m add command -label [m paste] -underline [ul 0] -accelerator "Ctl-Y" -command gat_yankFromBuf
    $m add command -label [m selall] -underline [ul 0] -accelerator "Ctl-X a" -command gat_selectAll
    $m add command -label [m find] -underline [ul 0] -accelerator "Ctl-F" -command tkg_findObject
    $m add separator
    $m add command -label [m algnv] -underline [ul 6] -accelerator "|" -command { gat_align 0 }
    $m add command -label [m algnh] -underline [ul 6] -accelerator "-" -command { gat_align 1 }
    $m add separator
    $m add command -label [m zoomin] -underline [ul 6] -accelerator "Ctl-z i" -command { gat_zoom 1 }
    $m add command -label [m zoomout] -underline [ul 6] -accelerator "Ctl-z o" -command { gat_zoom -1 }
}

######################################################################
#
# Tool selection menu
#
proc tkg_makeToolMenu {m} {
    global tkg_allowDebug

    menu $m
    $m add radiobutton -label [m move] -underline [ul 0] -variable mode -value 1 -accelerator F1
    $m add radiobutton -label [m delg] -underline [ul 0] -variable mode -value 3 -accelerator F2
    $m add radiobutton -label [m cutw] -underline [ul 0] -variable mode -value 0 -accelerator F3
    $m add radiobutton -label [m inv] -underline [ul 0] -variable mode -value 2 -accelerator F4
    $m add radiobutton -label [m bitw] -underline [ul 0] -variable mode -value 9 -accelerator F5
    if { $tkg_allowDebug } {
	$m add radiobutton -label [m debug] -underline [ul 0] -variable mode -value 12 -accelerator F6
    }
    $m add separator
    $m add radiobutton -label [m rot0] -underline [ul 4] -variable rot -value 0 -accelerator Ctl-F1
    $m add radiobutton -label [m rot90] -underline [ul 4] -variable rot -value 90 -accelerator Ctl-F2
    $m add radiobutton -label [m rot180] -underline [ul 4] -variable rot -value 180 -accelerator Ctl-F3
    $m add radiobutton -label [m rot270] -underline [ul 4] -variable rot -value 270 -accelerator Ctl-F4
}

######################################################################
#
# Circuit menu
#
proc tkg_makeCircMenu {m} {
  menu $m
  $m add command -label [m circprop] -underline [ul 8] -command tkg_editCircProp -accelerator "Ctl-x E"
  $m add command -label [m cpath] -underline [ul 8] -command tkg_cpathAnal -accelerator "Ctl-x r"
}

######################################################################
#
# Simulator menu
#
proc tkg_makeSimMenu {m s} {
  menu $m
  $m add command -label [m simbegin] -underline [ul 0] -command { gat_setMajorMode simulate } -accelerator "Ctl-S b"
  $m add separator
  $m add command -label [m simrun] -underline [ul 0] -command tkg_simRun -accelerator "Ctl-S g" -state $s
  $m add command -label [m simpause] -underline [ul 0] -command tkg_simStop  -accelerator "Ctl-S s" -state $s
  $m add command -label [m simstep] -underline [ul 0] -command tkg_simStep -accelerator "Space" -state $s
  $m add command -label [m simcycle] -underline [ul 5] -command tkg_simCycle -state $s -accelerator "Tab"
  $m add command -label [m simbreak] -underline [ul 0] -state $s -command tkg_editBreakpoints -accelerator "Ctl-S k"
  $m add command -label [m simscript] -underline [ul 1] -state $s -command tkg_doSimScript -accelerator "Ctl-S x"
  $m add separator
  $m add command -label [m simload] -underline [ul 1] -state $s -command tkg_simLoadMem -accelerator "Ctl-S l"
  $m add command -label [m simdump] -underline [ul 1] -state $s -command tkg_simDumpMem -accelerator "Ctl-S d"
}

######################################################################
#
# Module Operations
#
proc tkg_makeModuleMenu {m} {
    menu $m
    $m add command -label [m modopen] -underline [ul 0] -command gat_openBox -accelerator >
    $m add command -label [m modclose] -underline [ul 0] -command gat_closeBox -accelerator <
    $m add separator
    $m add command -label [m modseti] -underline [ul 0] -command gat_setBlockDesc -accelerator "Ctl-b s"
    $m add command -label [m modediti] -underline [ul 0] -command gat_editBlockDesc -accelerator "Ctl-b e"
    $m add separator
    $m add command -label [m modnew] -underline [ul 0] -accelerator "Ctl-b n" -command tkg_blockNew
    $m add command -label [m moddel] -underline [ul 0] -accelerator "Ctl-b d" -command tkg_blockDelete
    $m add command -label [m modcopy] -underline [ul 0] -accelerator "Ctl-b c" -command tkg_blockCopy
    $m add command -label [m modrename] -underline [ul 0] -accelerator "Ctl-b r" -command tkg_blockRename
    $m add command -label [m modclaim] -underline [ul 1] -accelerator "Ctl-b l" -command tkg_blockClaim
}

######################################################################
#
# Gate menu
#
proc tkg_makeGateMenu {m} {
  global gatesetech_w

  menu $m
  $m add command -label [m gataddin] -underline [ul 4] -command gat_addIn -accelerator \[
  $m add command -label [m gataddout] -underline [ul 4]  -command gat_addOut -accelerator \]
  $m add command -label [m gataddinout] -underline [ul 6] -command gat_addInOut -accelerator -
  $m add command -label [m gatiochg] -underline [ul 1]  -command gat_changePinDir -accelerator @
  $m add separator
  $m add command -label [m gatanchor] -underline [ul 0] -command {gat_anchor 1} -accelerator "Ctl-x f"
  $m add command -label [m gatunanchor] -underline [ul 0] -command {gat_anchor 0} -accelerator "Ctl-x u"
  $m add separator
  $m add command -label [m gatrep] -underline [ul 0] -command gat_replicate -accelerator Ctl-V
  $m add command -label [m gatdel] -underline [ul 0] -accelerator Del -command gat_deleteSelected
  $m add cascade -label [m gatsettech] -underline [ul 0] -menu $m.settech
  $m add command -label [m gatprop] -underline [ul 0] -command gat_editProps -accelerator E

  menu $m.settech -tearoff 0 
  set gatesetech_w $m.settech
}

######################################################################
#
# Gate creation menus - created based on data in each gate's .c file.
#
proc tkg_makeMakeMenu {m} {
  gat_makeMakeMenu $m
}

menubutton .mbar.file -text [m file] -underline [ul 0] -menu .mbar.file.menu
tkg_makeFileMenu .mbar.file.menu

menubutton .mbar.edit -text [m edit] -underline [ul 0] -menu .mbar.edit.menu 
tkg_makeEditMenu  .mbar.edit.menu

menubutton .mbar.tool -text [m tool] -underline [ul 0] -menu .mbar.tool.menu 
tkg_makeToolMenu .mbar.tool.menu

menubutton .mbar.circ -text [m circ] -underline [ul 0] -menu .mbar.circ.menu 
tkg_makeCircMenu .mbar.circ.menu

menubutton .mbar.sim -text [m simulate] -underline [ul 0] -menu .mbar.sim.menu
tkg_makeSimMenu .mbar.sim.menu normal

menubutton .mbar.module -text [m module] -underline [ul 1] -menu .mbar.module.menu
tkg_makeModuleMenu  .mbar.module.menu


menubutton .mbar.gate -text [m gate] -underline [ul 0] -menu .mbar.gate.menu
tkg_makeGateMenu  .mbar.gate.menu

menubutton .mbar.make -text [m make] -underline [ul 0] -menu .mbar.make.menu
tkg_makeMakeMenu  .mbar.make.menu

######################################################################
#
# Help menu
#
menubutton .mbar.help -text [m help] -underline [ul 0] -menu .mbar.help.menu
menu .mbar.help.menu
.mbar.help.menu add command -label [m hlpabout] -underline [ul 0] -command showAbout
.mbar.help.menu add command -label [m hlplicense] -underline [ul 0] -command showLicense
.mbar.help.menu add command -label [m hlpdoc] -underline [ul 0] -command showDocumentation
.mbar.help.menu add separator
.mbar.help.menu add cascade -label [m hlptut] -menu .mbar.help.menu.tut -underline [ul 1]
.mbar.help.menu add cascade -label [m hlpexample] -menu .mbar.help.menu.ex -underline [ul 1]

menu .mbar.help.menu.ex -tearoff 0
.mbar.help.menu.ex add command -label [m exampcomb] -underline [ul 0] -command "gat_load $tkgate_exampledir/ex1/combinational.v"
.mbar.help.menu.ex add command -label [m examp3bit] -underline [ul 0] -command "gat_load $tkgate_exampledir/ex2/flipflop.v"
.mbar.help.menu.ex add command -label [m examp8bit] -underline [ul 0] -command "gat_load $tkgate_exampledir/ex3/counter.v"
.mbar.help.menu.ex add command -label [m examptrff] -underline [ul 0] -command "gat_load $tkgate_exampledir/ex4/trff.v"
.mbar.help.menu.ex add command -label [m exampcpu] -underline [ul 12] -command "gat_load $tkgate_exampledir/ex5/menagerie.v"

menu .mbar.help.menu.tut -tearoff 0
.mbar.help.menu.tut add command -label [m tutwelcome] -underline [ul 0] -command "gat_load $tkgate_tutorialdir/welcome_tut.v"
.mbar.help.menu.tut add command -label [m tutcreate] -underline [ul 0] -command "gat_load $tkgate_tutorialdir/create_tut.v"
.mbar.help.menu.tut add command -label [m tutedit1] -underline [ul 19] -command "gat_load $tkgate_tutorialdir/edit1_tut.v"
.mbar.help.menu.tut add command -label [m tutedit2] -underline [ul 19] -command "gat_load $tkgate_tutorialdir/edit2_tut.v"
.mbar.help.menu.tut add command -label [m tutmods] -underline [ul 0] -command "gat_load $tkgate_tutorialdir/module_tut.v"
.mbar.help.menu.tut add command -label [m tutsim] -underline [ul 0] -command "gat_load $tkgate_tutorialdir/sim_tut.v"

######################################################################
#
# Final menu creation
#

pack .mbar.file .mbar.edit .mbar.tool .mbar.circ .mbar.sim .mbar.module .mbar.gate .mbar.make -in .mbar -side left
pack .mbar.help -in .mbar -side right

