//: version "1.6"
//: property discardChanges = 1

module ALU(F, A, B, Z);
//: interface  /sz:(89, 65) /bd:[ Ti0>A[7:0](20/89) Ti1>B[7:0](67/89) Li0>F[1:0](28/65) Bo0<Z[7:0](44/89) ]
input [7:0] B;    //: /sn:0 {0}(342,147)(342,184){1}
//: {2}(344,186)(367,186){3}
//: {4}(371,186)(425,186)(425,258){5}
//: {6}(369,188)(369,261){7}
//: {8}(342,188)(342,258){9}
input [1:0] F;    //: /sn:0 /dp:1 {0}(343,353)(214,353){1}
input [7:0] A;    //: /sn:0 {0}(265,147)(265,215){1}
//: {2}(267,217)(345,217){3}
//: {4}(349,217)(372,217){5}
//: {6}(376,217)(457,217)(457,258){7}
//: {8}(374,219)(374,261){9}
//: {10}(347,219)(347,258){11}
//: {12}(265,219)(265,322)(348,322)(348,337){13}
supply0 w0;    //: /sn:0 {0}(491,295)(491,272)(465,272){1}
output [7:0] Z;    //: /sn:0 {0}(366,404)(366,366){1}
wire [7:0] w14;    //: /sn:0 {0}(345,279)(345,310)(360,310)(360,337){1}
wire w4;    //: /sn:0 {0}(417,272)(407,272){1}
wire [7:0] w11;    //: /sn:0 {0}(372,282)(372,337){1}
wire [7:0] w10;    //: /sn:0 /dp:1 {0}(384,337)(384,307)(441,307)(441,287){1}
//: enddecls

  //: joint g8 (A) @(347, 217) /w:[ 4 -1 3 10 ]
  add g4 (.A(B), .B(A), .S(w10), .CI(w0), .CO(w4));   //: @(441,274) /sn:0 /w:[ 5 7 1 1 0 ]
  //: supply0 g13 (w0) @(491,301) /sn:0 /w:[ 0 ]
  //: input g3 (F) @(212,353) /sn:0 /w:[ 1 ]
  //: input g2 (A) @(265,145) /sn:0 /R:3 /w:[ 0 ]
  //: input g1 (B) @(342,145) /sn:0 /R:3 /w:[ 0 ]
  //: joint g11 (B) @(369, 186) /w:[ 4 -1 3 6 ]
  //: joint g10 (A) @(374, 217) /w:[ 6 -1 5 8 ]
  and g6 (.I0(B), .I1(A), .Z(w11));   //: @(372,272) /sn:0 /R:3 /w:[ 7 9 0 ]
  //: joint g9 (A) @(265, 217) /w:[ 2 1 -1 12 ]
  or g7 (.I0(B), .I1(A), .Z(w14));   //: @(345,269) /sn:0 /R:3 /w:[ 9 11 0 ]
  //: output g5 (Z) @(366,401) /sn:0 /R:3 /w:[ 0 ]
  mux g0 (.I0(A), .I1(w14), .I2(w11), .I3(w10), .S(F), .Z(Z));   //: @(366,353) /sn:0 /w:[ 13 1 1 0 0 1 ]
  //: joint g12 (B) @(342, 186) /w:[ 2 1 -1 8 ]

endmodule

module REGS(SB, SA, BOUT, AOUT, ck, AIN);
//: interface  /sz:(94, 80) /bd:[ Ti0>AIN[7:0](46/94) Li0>SA[1:0](14/80) Li1>SB[1:0](34/80) Li2>ck(56/80) Bi0>BOUT[7:0](79/94) Bi1>AOUT[7:0](16/94) ]
supply1 w0;    //: /sn:0 /dp:1 {0}(361,358)(373,358)(373,339){1}
supply1 w21;    //: /sn:0 /dp:1 {0}(260,211)(181,211)(181,173){1}
input [1:0] SB;    //: /sn:0 {0}(507,507)(570,507){1}
supply1 w1;    //: /sn:0 /dp:1 {0}(506,358)(519,358)(519,339){1}
output [7:0] BOUT;    //: /sn:0 {0}(593,549)(593,520){1}
input [1:0] SA;    //: /sn:0 {0}(382,507)(92,507)(92,138){1}
//: {2}(94,136)(284,136)(284,198){3}
//: {4}(90,136)(47,136){5}
supply1 w2;    //: /sn:0 /dp:1 {0}(219,357)(231,357)(231,340){1}
input [7:0] AIN;    //: /sn:0 {0}(467,144)(467,285){1}
//: {2}(469,287)(626,287)(626,353){3}
//: {4}(465,287)(324,287){5}
//: {6}(320,287)(180,287)(180,352){7}
//: {8}(322,289)(322,353){9}
//: {10}(467,289)(467,353){11}
input ck;    //: /sn:0 {0}(51,392)(124,392){1}
//: {2}(128,392)(273,392){3}
//: {4}(277,392)(412,392){5}
//: {6}(416,392)(574,392)(574,363)(589,363){7}
//: {8}(414,390)(414,363)(430,363){9}
//: {10}(275,390)(275,363)(285,363){11}
//: {12}(126,390)(126,362)(143,362){13}
output [7:0] AOUT;    //: /sn:0 /dp:1 {0}(405,520)(405,549){1}
supply1 w5;    //: /sn:0 /dp:1 {0}(665,358)(680,358)(680,340){1}
wire w4;    //: /sn:0 {0}(290,227)(290,266)(555,266)(555,368)(506,368){1}
wire [7:0] R2;    //: /dp:4 {0}(411,491)(411,432)(465,432){1}
//: {2}(469,432)(599,432)(599,491){3}
//: {4}(467,430)(467,374){5}
wire w3;    //: /sn:0 {0}(278,227)(278,281)(404,281)(404,368)(361,368){1}
wire w20;    //: /sn:0 {0}(302,227)(302,248)(712,248)(712,368)(665,368){1}
wire [7:0] R3;    //: /dp:3 {0}(423,491)(423,447)(609,447){1}
//: {2}(613,447)(626,447)(626,374){3}
//: {4}(611,449)(611,491){5}
wire [7:0] R1;    //: /dp:5 {0}(399,491)(399,422){1}
//: {2}(401,420)(587,420)(587,491){3}
//: {4}(397,420)(322,420)(322,374){5}
wire w8;    //: /sn:0 /dp:1 {0}(219,367)(266,367)(266,227){1}
wire [7:0] R0;    //: /dp:3 {0}(575,491)(575,460)(389,460){1}
//: {2}(385,460)(180,460)(180,373){3}
//: {4}(387,462)(387,491){5}
//: enddecls

  register g8 (.Q(R3), .D(AIN), .EN(w20), .CLR(w5), .CK(ck));   //: @(626,363) /sn:0 /w:[ 3 3 1 0 7 ]
  //: input g4 (SB) @(505,507) /sn:0 /w:[ 0 ]
  mux g13 (.I0(R0), .I1(R1), .I2(R2), .I3(R3), .S(SB), .Z(BOUT));   //: @(593,507) /sn:0 /w:[ 0 3 3 5 1 1 ]
  //: input g3 (SA) @(45,136) /sn:0 /w:[ 5 ]
  //: output g2 (BOUT) @(593,546) /sn:0 /R:3 /w:[ 0 ]
  //: output g1 (AOUT) @(405,546) /sn:0 /R:3 /w:[ 1 ]
  //: joint g16 (R0) @(387, 460) /w:[ 1 -1 2 4 ]
  //: joint g11 (ck) @(275, 392) /w:[ 4 10 3 -1 ]
  //: supply1 g10 (w21) @(192,173) /sn:0 /w:[ 1 ]
  //: joint g27 (ck) @(126, 392) /w:[ 2 12 1 -1 ]
  //: joint g19 (R1) @(399, 420) /w:[ 2 -1 4 1 ]
  register g6 (.Q(R1), .D(AIN), .EN(w3), .CLR(w0), .CK(ck));   //: @(322,363) /sn:0 /w:[ 5 9 1 0 11 ]
  demux g9 (.I(SA), .E(w21), .Z0(!w8), .Z1(!w3), .Z2(!w4), .Z3(!w20));   //: @(284,211) /sn:0 /w:[ 3 0 1 0 0 0 ]
  register g7 (.Q(R2), .D(AIN), .EN(w4), .CLR(w1), .CK(ck));   //: @(467,363) /sn:0 /w:[ 5 11 1 0 9 ]
  register g15 (.Q(R0), .D(AIN), .EN(w8), .CLR(w2), .CK(ck));   //: @(180,362) /sn:0 /w:[ 3 7 0 0 13 ]
  //: joint g20 (SA) @(92, 136) /w:[ 2 -1 4 1 ]
  //: supply1 g25 (w2) @(242,340) /sn:0 /w:[ 1 ]
  //: joint g17 (R3) @(611, 447) /w:[ 2 -1 1 4 ]
  mux g14 (.I0(R0), .I1(R1), .I2(R2), .I3(R3), .S(SA), .Z(AOUT));   //: @(405,507) /sn:0 /w:[ 5 0 0 0 0 0 ]
  //: input g5 (ck) @(49,392) /sn:0 /w:[ 0 ]
  //: joint g24 (AIN) @(467, 287) /w:[ 2 1 4 10 ]
  //: supply1 g21 (w0) @(384,339) /sn:0 /w:[ 1 ]
  //: supply1 g23 (w5) @(691,340) /sn:0 /w:[ 1 ]
  //: joint g26 (AIN) @(322, 287) /w:[ 5 -1 6 8 ]
  //: supply1 g22 (w1) @(530,339) /sn:0 /w:[ 1 ]
  //: input g0 (AIN) @(467,142) /sn:0 /R:3 /w:[ 0 ]
  //: joint g18 (R2) @(467, 432) /w:[ 2 4 1 -1 ]
  //: joint g12 (ck) @(414, 392) /w:[ 6 8 5 -1 ]

endmodule

module main;    //: root_module
supply1 w7;    //: /sn:0 {0}(256,325)(256,312){1}
supply0 w2;    //: /sn:0 {0}(295,430)(295,445)(258,445){1}
//: {2}(254,445)(223,445)(223,429){3}
//: {4}(256,447)(256,457){5}
supply0 w12;    //: /sn:0 {0}(478,499)(478,481)(460,481){1}
supply0 w11;    //: /sn:0 {0}(496,395)(496,373)(480,373){1}
supply1 w10;    //: /sn:0 /dp:1 {0}(460,471)(474,471)(474,453){1}
supply0 [7:0] w9;    //: /sn:0 {0}(387,395)(387,385)(411,385)(411,414){1}
wire [7:0] w6;    //: /sn:0 /dp:1 {0}(711,277)(711,265)(771,265){1}
//: {2}(775,265)(817,265)(817,561)(695,561)(695,538){3}
//: {4}(773,263)(773,252){5}
wire b;    //: /dp:1 {0}(62,491)(98,491){1}
//: {2}(100,489)(100,461)(116,461){3}
//: {4}(100,493)(100,537)(128,537){5}
wire [7:0] w14;    //: /sn:0 /dp:1 {0}(440,359)(440,332){1}
wire [7:0] w16;    //: /sn:0 {0}(431,414)(431,400)(456,400)(456,388){1}
wire [7:0] w15;    //: /sn:0 /dp:1 {0}(748,364)(748,335)(771,335){1}
//: {2}(775,335)(798,335)(798,552)(758,552)(758,538){3}
//: {4}(773,333)(773,320){5}
wire w4;    //: /sn:0 /dp:1 {0}(194,535)(149,535){1}
wire w19;    //: /sn:0 /dp:1 {0}(398,430)(361,430){1}
wire w0;    //: /sn:0 {0}(157,333)(229,333){1}
//: {2}(233,333)(242,333){3}
//: {4}(231,331)(231,323){5}
//: {6}(231,335)(231,421)(281,421){7}
wire w3;    //: /sn:0 /dp:1 {0}(194,530)(164,530)(164,514){1}
wire [1:0] w21;    //: /sn:0 {0}(635,453)(652,453)(652,471)(678,471){1}
wire w28;    //: /sn:0 {0}(637,293)(678,293){1}
wire [1:0] w23;    //: /sn:0 /dp:1 {0}(678,491)(651,491)(651,503)(637,503){1}
wire [7:0] w20;    //: /sn:0 {0}(421,443)(421,466){1}
wire w1;    //: /sn:0 {0}(156,367)(192,367){1}
//: {2}(196,367)(242,367){3}
//: {4}(194,365)(194,358){5}
//: {6}(194,369)(194,420)(209,420){7}
wire co;    //: /dp:1 {0}(215,533)(228,533)(228,522){1}
wire [7:0] w25;    //: /sn:0 {0}(658,233)(691,233)(691,277){1}
wire w8;    //: /sn:0 /dp:1 {0}(191,459)(163,459){1}
//: {2}(159,459)(137,459){3}
//: {4}(161,461)(161,493){5}
wire w18;    //: /sn:0 {0}(432,373)(422,373){1}
wire [7:0] w17;    //: /sn:0 {0}(725,456)(725,431){1}
wire ci;    //: {0}(62,420)(166,420)(166,462){1}
//: {2}(168,464)(191,464){3}
//: {4}(166,466)(166,493){5}
wire clk;    //: {0}(323,476)(384,476){1}
wire w13;    //: /sn:0 {0}(223,412)(223,393)(254,393){1}
//: {2}(258,393)(293,393){3}
//: {4}(295,391)(295,381){5}
//: {6}(295,395)(295,413){7}
//: {8}(256,391)(256,376){9}
wire s;    //: /dp:1 {0}(212,462)(230,462)(230,479){1}
wire ck;    //: /sn:0 {0}(611,559)(665,559)(665,513)(678,513){1}
wire w5;    //: /sn:0 /dp:1 {0}(256,342)(256,359){1}
wire a;    //: {0}(62,456)(104,456){1}
//: {2}(108,456)(116,456){3}
//: {4}(106,458)(106,532)(128,532){5}
wire [7:0] w29;    //: /sn:0 /dp:1 {0}(701,364)(701,306){1}
wire [7:0] reg_out;    //: {0}(421,487)(421,523)(466,523){1}
//: {2}(470,523)(520,523)(520,348)(472,348)(472,359){3}
//: {4}(468,525)(468,542){5}
wire [1:0] w26;    //: /sn:0 /dp:1 {0}(637,356)(658,356)(658,393)(680,393){1}
//: enddecls

  //: comment g61 /dolink:1 /link:"@T/edwire_tut.v" @(622,100) /sn:0 /anc:1
  //: /line:"磻Խ"
  //: /end
  nmos g4 (.Z(w2), .S0(w13), .G0(w0));   //: @(289,421) /sn:0 /w:[ 0 7 7 ]
  //: supply1 g8 (w7) @(267,312) /sn:0 /w:[ 1 ]
  clock g51 (.Z(ck));   //: @(598,559) /sn:0 /w:[ 0 ] /omega:200 /phi:0 /duty:50
  //: switch g3 (w0) @(140,333) /sn:0 /w:[ 0 ] /st:0
  //: joint g13 (w1) @(194, 367) /w:[ 2 4 1 6 ]
  or g34 (.I0(w3), .I1(w4), .Z(co));   //: @(205,533) /sn:0 /w:[ 0 0 0 ]
  clock g37 (.Z(clk));   //: @(310,476) /sn:0 /w:[ 0 ] /omega:120 /phi:0 /duty:50
  led g55 (.I(w0));   //: @(231,316) /sn:0 /w:[ 5 ] /type:0
  //: joint g58 (w6) @(773, 265) /w:[ 2 4 1 -1 ]
  //: comment g2 /dolink:0 /link:"" @(-2,217) /sn:0 /anc:1
  //: /line:""
  //: /end
  led g59 (.I(w15));   //: @(773,313) /sn:0 /w:[ 5 ] /type:2
  //: comment g1 /dolink:1 /link:"@T/edit1_tut.v" @(622,70) /sn:0 /anc:1
  //: /line:"ܤԽ⡼"
  //: /end
  //: comment g16 /dolink:1 /link:"@T/module_tut.v" @(622,115) /sn:0 /anc:1
  //: /line:"⥸塼λȤ"
  //: /end
  //: joint g11 (w2) @(256, 445) /w:[ 1 -1 2 4 ]
  led g50 (.I(co));   //: @(228,515) /sn:0 /w:[ 1 ] /type:0
  //: supply0 g10 (w2) @(256,463) /sn:0 /w:[ 5 ]
  and g28 (.I0(a), .I1(b), .Z(w4));   //: @(139,535) /sn:0 /w:[ 5 5 1 ]
  //: joint g19 (w0) @(231, 333) /w:[ 2 4 1 6 ]
  //: switch g27 (ci) @(45,420) /sn:0 /w:[ 0 ] /st:0
  //: joint g32 (w8) @(161, 459) /w:[ 1 -1 2 4 ]
  //: dip sa (w21) @(597,453) /R:1 /w:[ 0 ] /st:0
  nmos g6 (.Z(w2), .S0(w13), .G0(w1));   //: @(217,420) /sn:0 /w:[ 3 0 7 ]
  //: supply0 g38 (w12) @(478,505) /sn:0 /w:[ 0 ]
  mux g53 (.I0(w25), .I1(w6), .S(w28), .Z(w29));   //: @(701,293) /sn:0 /w:[ 1 0 1 1 ]
  pmos g7 (.Z(w7), .S0(w5), .G0(w0));   //: @(250,333) /sn:0 /w:[ 0 0 3 ]
  //: joint g9 (w13) @(256, 393) /w:[ 2 8 1 -1 ]
  //: joint g57 (w13) @(295, 393) /w:[ -1 4 3 6 ]
  //: frame g15 @(600,25) /sn:0 /anc:1 /wi:224 /ht:149 /tx:"塼ȥꥢ"
  //: comment g20 /dolink:1 /link:"@T/create_tut.v" @(622,55) /sn:0 /anc:1
  //: /line:"ϩκ"
  //: /end
  and g31 (.I0(w8), .I1(ci), .Z(w3));   //: @(164,504) /sn:0 /R:3 /w:[ 5 5 1 ]
  //: dip sb (w23) @(599,503) /R:1 /w:[ 1 ] /st:1
  //: supply1 g39 (w10) @(485,453) /sn:0 /w:[ 1 ]
  led g48 (.I(reg_out));   //: @(468,549) /sn:0 /R:2 /w:[ 5 ] /type:1
  //: dip func (w26) @(599,356) /R:1 /w:[ 0 ] /st:0
  //: supply0 g43 (w11) @(496,401) /sn:0 /w:[ 0 ]
  REGS regs (.AIN(w17), .ck(ck), .SB(w23), .SA(w21), .AOUT(w6), .BOUT(w15));   //: @(679, 457) /sz:(94, 80) /p:[ Ti0>0 Li0>1 Li1>0 Li2>1 Bi0>3 Bi1>3 ]
  ALU alu (.B(w15), .A(w29), .F(w26), .Z(w17));   //: @(681, 365) /sz:(89, 65) /p:[ Ti0>0 Ti1>0 Li0>1 Bo0<1 ]
  //: comment g17 /dolink:1 /link:"@T/sim_tut.v" @(622,130) /sn:0 /anc:1
  //: /line:"ȹ礻ϩΥߥ졼"
  //: /end
  //: switch g25 (a) @(45,456) /sn:0 /w:[ 0 ] /st:0
  //: joint g29 (a) @(106, 456) /w:[ 2 -1 1 4 ]
  led g62 (.I(w6));   //: @(773,245) /sn:0 /w:[ 5 ] /type:2
  led g52 (.I(s));   //: @(230,486) /sn:0 /R:2 /w:[ 1 ] /type:0
  //: dip g42 (w14) @(440,322) /sn:0 /w:[ 1 ] /st:248
  //: dip data_in (w25) @(620,233) /R:1 /w:[ 0 ] /st:11
  pmos g5 (.Z(w5), .S0(w13), .G0(w1));   //: @(250,367) /sn:0 /w:[ 1 9 3 ]
  led g56 (.I(w13));   //: @(295,374) /sn:0 /w:[ 5 ] /type:0
  //: comment g14 /dolink:1 /link:"@T/seqsim_tut.v" @(622,145) /sn:0 /anc:1
  //: /line:"ϩΥߥ졼"
  //: /end
  //: switch g44 (w19) @(344,430) /sn:0 /w:[ 1 ] /st:1
  //: comment g47 /dolink:0 /link:"" @(106,285) /sn:0
  //: /line:"˥åơϤ褦!"
  //: /end
  //: comment g21 /dolink:1 /link:"@T/edit2_tut.v" @(622,85) /sn:0 /anc:1
  //: /line:"롼פԽǽ"
  //: /end
  xor g24 (.I0(w8), .I1(ci), .Z(s));   //: @(202,462) /sn:0 /w:[ 0 3 0 ]
  add g36 (.A(w14), .B(reg_out), .S(w16), .CI(w11), .CO(w18));   //: @(456,375) /sn:0 /w:[ 0 3 1 1 0 ]
  xor g23 (.I0(a), .I1(b), .Z(w8));   //: @(127,459) /sn:0 /w:[ 3 3 3 ]
  //: supply0 g41 (w9) @(387,401) /sn:0 /w:[ 0 ]
  mux g40 (.I0(w9), .I1(w16), .S(w19), .Z(w20));   //: @(421,430) /sn:0 /w:[ 1 0 0 0 ]
  led g54 (.I(w1));   //: @(194,351) /sn:0 /w:[ 5 ] /type:0
  //: joint g60 (w15) @(773, 335) /w:[ 2 4 1 -1 ]
  //: switch data_select (w28) @(620,293) /w:[ 0 ] /st:0
  //: comment g22 /dolink:0 /link:"" @(605,40) /sn:0 /anc:1
  //: /line:"->"
  //: /end
  //: comment g0 /dolink:0 /link:"" @(13,16) /anc:1
  //: /line:"TkGateؤ褦!"
  //: /line:""
  //: /line:"Copyright (C) 1987-2000 by Jeffery P. Hansen"
  //: /line:"  TKGate comes with ABSOLUTELY NO WARRANTY; see 'Help...License' menu"
  //: /line:"  for license and warranty details.  Report problems to hansen@cmu.edu"
  //: /line:""
  //: /line:"   * TkGate¹ԤΥ塼ȥꥢ뤬ưŪɤ߹ޤ롣εǽ"
  //: /line:"     ̵ˤ١֥եפβΡ...פ򤷤ơֽ鿴ԥ⡼ɡפ"
  //: /line:"     åܥäƲ"
  //: /line:""
  //: /line:"    * ϩ١֥եפβΡֿפ򤷤Ƥ"
  //: /line:"     ¸ߤƤϩԽ١֥եפβΡֳ...פ򤷤Ƥ"
  //: /line:""
  //: /line:"   * TkGateΥɥȤʤɤhttp://www.cs.cmu.edu/~hansen/tkgateˤ롣"
  //: /line:""
  //: /line:"Υ塼ȥꥢǤϡTkGateδܤλȤҲ𤹤롣Υϥѡ󥯡"
  //: /line:"ϡ֥إספΥ˥塼ǡ줾Υ塼ȥꥢ򸫤Ƥ"
  //: /line:"ƥ塼ȥꥢ˽äơTkGateƲƤΥ塼"
  //: /line:"ꥢ򽪤ä顢֥إסץ˥塼ǴĤϩɤ߹롣"
  //: /line:""
  //: /end
  //: switch g26 (b) @(45,491) /sn:0 /w:[ 0 ] /st:1
  register g35 (.Q(reg_out), .D(w20), .EN(w12), .CLR(w10), .CK(clk));   //: @(421,476) /sn:0 /w:[ 0 1 1 0 1 ]
  //: comment g46 /dolink:1 /link:"@T/create_tut.v" @(11,285) /sn:0
  //: /line:"ֲϩκ"
  //: /end
  //: comment g18 /dolink:0 /link:"@T/welcome_tut.v" @(622,40) /sn:0 /anc:1
  //: /line:"TkGateξҲ"
  //: /end
  //: switch g12 (w1) @(139,367) /sn:0 /w:[ 0 ] /st:0
  //: joint g30 (b) @(100, 491) /w:[ -1 2 1 4 ]
  //: joint g33 (ci) @(166, 464) /w:[ 2 1 -1 4 ]
  //: joint g49 (reg_out) @(468, 523) /w:[ 2 -1 1 4 ]

endmodule
