//: version "1.6"
//: property discardChanges = 1
//: script "menagerie.gss"


module MEMORY(DATA, spc, _ldpc, _wrt, _rd, _ldmdr, _ldhmdr, _rdmdr, _rdpc, _CLR, _incmar, _ldmar, CK, _incpc);
//: interface  /sz:(125, 353) /bd:[ Ti0>CK(33/125) Ti1>_CLR(83/125) Bi0>DATA[15:0](60/125) Ri0>_ldpc(25/353) Ri1>_ldmar(42/353) Ri2>_ldmdr(57/353) Ri3>_incpc(73/353) Ri4>_rdmdr(88/353) Ri5>_wrt(104/353) Ri6>_rd(120/353) Ri7>spc(136/353) Ri8>_ldhmdr(155/353) Ri9>_rdpc(171/353) Ri10>_incmar(186/353) ]
input _rdpc;    //: /sn:0 {0}(259,285)(270,285)(270,306){1}
input _rd;    //: /sn:0 {0}(671,557)(671,614){1}
//: {2}(673,616)(708,616)(708,273)(740,273){3}
//: {4}(669,616)(512,616){5}
//: {6}(510,614)(510,579){7}
//: {8}(508,616)(482,616){9}
supply0 [5:0] w16;    //: /sn:0 {0}(545,861)(545,840){1}
input CK;    //: /sn:0 /dp:1 {0}(753,813)(742,813)(742,833)(618,833)(618,815){1}
//: {2}(620,813)(631,813){3}
//: {4}(616,813)(524,813)(524,438){5}
//: {6}(526,436)(641,436)(641,334)(726,334){7}
//: {8}(522,436)(130,436){9}
//: {10}(128,434)(128,335){11}
//: {12}(130,333)(321,333)(321,307)(326,307){13}
//: {14}(128,331)(128,253)(151,253){15}
//: {16}(126,436)(62,436){17}
supply0 [7:0] w3;    //: /sn:0 {0}(683,269)(683,251)(662,251){1}
input _CLR;    //: /sn:0 {0}(512,218)(512,201){1}
//: {2}(514,199)(844,199)(844,327){3}
//: {4}(842,329)(802,329){5}
//: {6}(844,331)(844,770){7}
//: {8}(842,772)(716,772)(716,808)(707,808){9}
//: {10}(844,774)(844,808)(829,808){11}
//: {12}(510,199)(409,199){13}
//: {14}(405,199)(263,199)(263,248)(227,248){15}
//: {16}(407,201)(407,302)(402,302){17}
input _ldhmdr;    //: /sn:0 {0}(673,103)(709,103){1}
//: {2}(713,103)(871,103)(871,269){3}
//: {4}(711,105)(711,137){5}
input _wrt;    //: /sn:0 {0}(691,706)(424,706){1}
//: {2}(422,704)(422,510){3}
//: {4}(424,508)(454,508){5}
//: {6}(420,508)(399,508){7}
//: {8}(422,708)(422,758)(692,758){9}
input _ldmar;    //: /sn:0 {0}(458,247)(458,314)(438,314){1}
supply0 [15:0] w21;    //: /sn:0 {0}(220,59)(220,42)(194,42)(194,69){1}
input _ldpc;    //: /sn:0 {0}(233,131)(217,131)(217,152)(148,152){1}
//: {2}(144,152)(131,152){3}
//: {4}(146,154)(146,204)(165,204){5}
inout [15:0] DATA;    //: /sn:0 /dp:13 {0}(278,311)(297,311)(297,213)(371,213){1}
//: {2}(373,211)(373,167){3}
//: {4}(375,165)(508,165){5}
//: {6}(512,165)(547,165){7}
//: {8}(551,165)(568,165){9}
//: {10}(549,167)(549,246)(616,246){11}
//: {12}(510,163)(510,134){13}
//: {14}(371,165)(198,165)(198,188){15}
//: {16}(373,215)(373,248){17}
supply0 [7:0] w24;    //: /sn:0 {0}(595,538)(595,523){1}
supply1 w20;    //: /sn:0 {0}(241,70)(241,83)(202,83){1}
supply0 w23;    //: /sn:0 {0}(829,818)(844,818)(844,836){1}
supply0 [7:0] w1;    //: /sn:0 {0}(800,724)(800,677)(825,677)(825,687){1}
input _rdmdr;    //: /sn:0 {0}(624,284)(624,251){1}
input _incpc;    //: /sn:0 {0}(233,126)(133,126){1}
input spc;    //: /sn:0 {0}(251,380)(207,380){1}
supply0 w17;    //: /sn:0 {0}(496,579)(496,592){1}
input _ldmdr;    //: /sn:0 /dp:1 {0}(876,269)(876,80)(673,80){1}
input _incmar;    //: /sn:0 {0}(438,309)(448,309)(448,281)(327,281){1}
//: {2}(325,279)(325,266){3}
//: {4}(327,264)(340,264){5}
//: {6}(325,262)(325,243){7}
//: {8}(325,283)(325,293)(313,293)(313,326)(223,326)(223,411)(96,411)(96,383){9}
wire [15:0] w6;    //: /sn:0 {0}(162,69)(162,47)(70,47)(70,360)(83,360){1}
wire [7:0] mdrin;    //: /sn:0 {0}(520,552)(557,552){1}
//: {2}(561,552)(663,552){3}
//: {4}(559,550)(559,523){5}
wire w46;    //: /sn:0 {0}(402,312)(417,312){1}
wire w14;    //: /sn:0 {0}(254,129)(272,129)(272,258)(227,258){1}
wire w15;    //: /sn:0 {0}(691,711)(645,711){1}
//: {2}(643,709)(643,672){3}
//: {4}(641,711)(436,711){5}
//: {6}(434,709)(434,512)(454,512){7}
//: {8}(432,711)(365,711){9}
wire [15:0] w19;    //: /sn:0 {0}(188,217)(188,243){1}
wire [15:0] w4;    //: /sn:0 {0}(584,165)(614,165){1}
wire [15:0] w38;    //: /sn:0 {0}(210,713)(300,713){1}
wire [15:0] PC;    //: /sn:0 {0}(188,264)(188,309){1}
//: {2}(190,311)(262,311){3}
//: {4}(188,313)(188,348){5}
//: {6}(190,350)(264,350)(264,364){7}
//: {8}(186,350)(112,350){9}
wire w;    //: /sn:0 {0}(802,339)(874,339)(874,290){1}
wire DTR;    //: /sn:0 {0}(451,982)(565,982)(565,840){1}
wire w37;    //: /sn:0 {0}(713,761)(722,761)(722,818)(707,818){1}
wire [7:0] w34;    //: /sn:0 {0}(555,834)(555,668)(571,668)(571,523){1}
wire [15:0] w43;    //: /sn:0 {0}(363,297)(363,277){1}
wire RTS;    //: /sn:0 {0}(451,958)(555,958)(555,840){1}
wire w31;    //: /sn:0 {0}(366,763)(446,763){1}
//: {2}(450,763)(631,763){3}
//: {4}(635,763)(692,763){5}
//: {6}(633,761)(633,672){7}
//: {8}(448,761)(448,515)(454,515){9}
wire [15:0] w28;    //: /sn:0 {0}(344,711)(321,711){1}
wire DSR;    //: /sn:0 {0}(451,974)(800,974)(800,858){1}
wire [7:0] w36;    //: /sn:0 {0}(790,753)(790,803){1}
wire CTS;    //: /sn:0 {0}(451,966)(790,966)(790,858){1}
wire [7:0] w25;    //: /sn:0 {0}(763,286)(763,324){1}
wire [15:0] w40;    //: /sn:0 {0}(212,765)(301,765){1}
wire [5:0] w35;    //: /sn:0 {0}(780,858)(780,881)(760,881){1}
wire [7:0] w8;    //: /sn:0 {0}(620,170)(695,170){1}
wire [15:0] w18;    //: /sn:0 {0}(274,393)(274,550){1}
//: {2}(276,552)(485,552){3}
//: {4}(274,554)(274,706){5}
//: {6}(276,708)(300,708){7}
//: {8}(274,710)(274,760)(301,760){9}
wire [15:0] w30;    //: /sn:0 {0}(345,763)(322,763){1}
wire w22;    //: /sn:0 {0}(154,83)(144,83){1}
wire [7:0] RD;    //: /sn:0 {0}(668,824)(668,949)(451,949){1}
wire [7:0] mdr;    //: /sn:0 {0}(780,724)(780,676)(724,676){1}
//: {2}(722,674)(722,552)(699,552){3}
//: {4}(697,550)(697,379){5}
//: {6}(699,377)(763,377)(763,345){7}
//: {8}(697,375)(697,241)(662,241){9}
//: {10}(695,552)(679,552){11}
//: {12}(720,676)(668,676)(668,803){13}
wire [15:0] w2;    //: /sn:0 {0}(656,246)(632,246){1}
wire w11;    //: /sn:0 {0}(503,529)(503,512)(475,512){1}
wire [1:0] w27;    //: /sn:0 {0}(600,507)(638,507)(638,666){1}
wire [7:0] w13;    //: /sn:0 {0}(753,257)(753,198)(577,198)(577,494){1}
wire [15:0] mar;    //: /sn:0 {0}(363,318)(363,349){1}
//: {2}(361,351)(284,351)(284,364){3}
//: {4}(363,353)(363,400)(136,400)(136,370)(112,370){5}
wire [7:0] w33;    //: /sn:0 {0}(790,852)(790,824){1}
wire [7:0] w5;    //: /sn:0 {0}(620,160)(661,160)(661,150)(695,150){1}
wire [7:0] TD;    //: /sn:0 {0}(451,941)(583,941)(583,523){1}
wire [15:0] w9;    //: /sn:0 {0}(178,188)(178,114){1}
//: {2}(178,110)(178,98){3}
//: {4}(180,112)(353,112)(353,248){5}
wire [7:0] w42;    //: /sn:0 {0}(773,257)(773,160)(724,160){1}
wire w26;    //: /sn:0 {0}(712,709)(745,709)(745,740)(767,740){1}
//: enddecls

  //: joint g4 (_rd) @(510, 616) /w:[ 5 6 8 -1 ]
  //: inout g8 (DATA) @(510,128) /sn:0 /R:3 /w:[ 13 ]
  //: joint g61 (w31) @(448, 763) /w:[ 2 8 1 -1 ]
  //: joint g58 (_CLR) @(844, 772) /w:[ -1 7 8 10 ]
  register g51 (.Q(RD), .D(mdr), .EN(w37), .CLR(_CLR), .CK(CK));   //: @(668,813) /sn:0 /w:[ 0 13 1 9 3 ]
  //: input g37 (spc) @(205,380) /sn:0 /w:[ 1 ]
  //: input g34 (_ldpc) @(129,152) /sn:0 /w:[ 3 ]
  //: input g13 (_wrt) @(397,508) /sn:0 /w:[ 7 ]
  //: joint g86 (_wrt) @(422, 508) /w:[ 4 -1 6 3 ]
  //: joint g55 (CK) @(524, 436) /w:[ 6 -1 8 5 ]
  //: joint g3 (_CLR) @(512, 199) /w:[ 2 -1 12 1 ]
  //: comment g89 /dolink:0 /link:"" @(37,543) /sn:0
  //: /line:"This is the memory address line."
  //: /line:"The address can be selected from"
  //: /line:"the MAR (Memory Address Register)"
  //: /line:"or from the PC (Program Counter)."
  //: /end
  //: input g2 (_rd) @(480,616) /sn:0 /w:[ 9 ]
  //: joint g65 (mdr) @(722, 676) /w:[ 1 2 12 -1 ]
  //: joint g76 (w9) @(178, 112) /w:[ 2 1 4 -1 ]
  //: input g77 (_ldmdr) @(671,80) /sn:0 /w:[ 1 ]
  nand g59 (.I0(!_wrt), .I1(w31), .Z(w37));   //: @(703,761) /sn:0 /w:[ 9 5 0 ]
  bufif0 g72 (.Z(DATA), .I(PC), .E(_rdpc));   //: @(268,311) /sn:0 /w:[ 0 3 1 ]
  register PC (.Q(PC), .D(w19), .EN(w14), .CLR(_CLR), .CK(CK));   //: @(188,253) /w:[ 0 1 1 15 15 ]
  //: supply0 g1 (w17) @(496,598) /sn:0 /w:[ 1 ]
  //: joint g64 (_wrt) @(422, 706) /w:[ 1 2 -1 8 ]
  //: frame g16 @(110,659) /sn:0 /wi:762 /ht:347 /tx:"TTY Control"
  mux g11 (.I0(mdrin), .I1(w34), .I2(TD), .I3(w24), .S(w27), .Z(w13));   //: @(577,507) /sn:0 /R:2 /w:[ 5 1 1 1 0 1 ]
  concat g50 (.I0(DSR), .I1(CTS), .I2(w35), .Z(w33));   //: @(790,853) /sn:0 /R:1 /w:[ 1 1 0 0 ] /dr:0
  add g28 (.A(w6), .B(w21), .S(w9), .CI(w20), .CO(w22));   //: @(178,85) /sn:0 /w:[ 0 1 3 1 0 ]
  //: joint g78 (PC) @(188, 350) /w:[ 6 5 8 -1 ]
  //: comment g87 /dolink:0 /link:"" @(210,776)
  //: /line:"These dip switches specify the"
  //: /line:"addresses for the tty status"
  //: /line:"and data registers."
  //: /end
  //: joint g10 (CK) @(128, 333) /w:[ 12 14 -1 11 ]
  //: joint g27 (DATA) @(373, 165) /w:[ 4 -1 14 3 ]
  //: joint g19 (mdr) @(697, 552) /w:[ 3 4 10 -1 ]
  mux g32 (.I0(w9), .I1(DATA), .S(_incmar), .Z(w43));   //: @(363,264) /sn:0 /w:[ 5 17 5 1 ]
  ram m1 (.A(w18), .D(mdrin), .WE(w11), .OE(_rd), .CS(w17));   //: @(503,553) /w:[ 3 0 0 7 0 ]
  //: joint g38 (DATA) @(549, 165) /w:[ 8 -1 7 10 ]
  //: input g69 (_ldhmdr) @(671,103) /sn:0 /w:[ 0 ]
  //: input g6 (_rdmdr) @(624,286) /sn:0 /R:1 /w:[ 0 ]
  //: joint g57 (_CLR) @(844, 329) /w:[ -1 3 4 6 ]
  register g53 (.Q(w33), .D(w36), .EN(w23), .CLR(_CLR), .CK(CK));   //: @(790,813) /sn:0 /w:[ 1 1 0 11 0 ]
  mux g9 (.I0(w13), .I1(w42), .S(_rd), .Z(w25));   //: @(763,273) /sn:0 /w:[ 0 0 3 0 ]
  bufif1 g7 (.Z(mdrin), .I(mdr), .E(_rd));   //: @(673,552) /sn:0 /R:2 /w:[ 3 11 0 ]
  //: joint g75 (DATA) @(373, 213) /w:[ -1 2 1 16 ]
  //: supply0 g20 (w3) @(683,275) /sn:0 /w:[ 0 ]
  concat g15 (.I0(w5), .I1(w8), .Z(w4));   //: @(615,165) /sn:0 /R:2 /w:[ 0 0 1 ] /dr:0
  //: joint g71 (_ldhmdr) @(711, 103) /w:[ 2 -1 1 4 ]
  mux g31 (.I0(PC), .I1(mar), .S(!_incmar), .Z(w6));   //: @(96,360) /sn:0 /R:3 /w:[ 9 5 9 1 ]
  xor g39 (.I0(w18), .I1(w38), .Z(w28));   //: @(311,711) /sn:0 /w:[ 7 1 1 ]
  //: supply0 g67 (w23) @(844,842) /sn:0 /w:[ 1 ]
  mux g68 (.I0(w5), .I1(w8), .S(!_ldhmdr), .Z(w42));   //: @(711,160) /sn:0 /R:1 /w:[ 1 1 5 1 ]
  //: supply0 g48 (w16) @(545,867) /sn:0 /w:[ 0 ]
  //: joint g43 (w18) @(274, 552) /w:[ 2 1 -1 4 ]
  //: input g73 (_rdpc) @(257,285) /sn:0 /w:[ 0 ]
  nand g62 (.I0(!_wrt), .I1(w15), .Z(w26));   //: @(702,709) /sn:0 /w:[ 0 0 0 ]
  //: supply1 g29 (w20) @(252,70) /sn:0 /w:[ 0 ]
  mux g25 (.I0(PC), .I1(mar), .S(!spc), .Z(w18));   //: @(274,380) /sn:0 /w:[ 7 3 0 0 ]
  //: joint g17 (DATA) @(510, 165) /w:[ 6 12 5 -1 ]
  //: input g88 (_CLR) @(512,220) /sn:0 /R:1 /w:[ 0 ]
  //: joint g63 (w15) @(643, 711) /w:[ 1 2 4 -1 ]
  nor g42 (.I0(w30), .Z(w31));   //: @(356,763) /sn:0 /w:[ 0 0 ]
  //: joint g52 (mdr) @(697, 377) /w:[ 6 8 -1 5 ]
  nor g83 (.I0(!_incmar), .I1(!_ldmar), .Z(w46));   //: @(427,312) /sn:0 /R:2 /w:[ 0 1 1 ]
  //: joint g74 (PC) @(188, 311) /w:[ 2 1 -1 4 ]
  //: joint g56 (CK) @(618, 813) /w:[ 2 -1 4 1 ]
  //: frame g14 @(536,27) /sn:0 /wi:372 /ht:394 /tx:"MDR Control"
  //: joint g5 (_CLR) @(407, 199) /w:[ 13 -1 14 16 ]
  concat g47 (.I0(DTR), .I1(RTS), .I2(w16), .Z(w34));   //: @(555,835) /sn:0 /R:1 /w:[ 1 1 1 0 ] /dr:0
  //: joint g44 (w18) @(274, 708) /w:[ 6 5 -1 8 ]
  //: joint g79 (mar) @(363, 351) /w:[ -1 1 2 4 ]
  //: input g80 (_incmar) @(325,241) /sn:0 /R:3 /w:[ 7 ]
  //: joint g36 (_ldpc) @(146, 152) /w:[ 1 -1 2 4 ]
  bufif0 g21 (.Z(DATA), .I(w2), .E(_rdmdr));   //: @(626,246) /sn:0 /R:2 /w:[ 11 1 1 ]
  register mdr (.Q(mdr), .D(w25), .EN(w), .CLR(_CLR), .CK(CK));   //: @(763,334) /w:[ 7 1 0 5 7 ]
  or g84 (.I0(_wrt), .I1(w15), .I2(w31), .Z(w11));   //: @(465,512) /sn:0 /w:[ 5 7 9 1 ]
  //: joint g85 (w15) @(434, 711) /w:[ 5 6 8 -1 ]
  //: joint g24 (CK) @(128, 436) /w:[ 9 10 16 -1 ]
  //: dip TTYSTATUS (w38) @(172,713) /R:1 /w:[ 0 ] /st:16
  nor g41 (.I0(w28), .Z(w15));   //: @(355,711) /sn:0 /w:[ 0 9 ]
  //: input g23 (_ldmar) @(458,245) /sn:0 /R:3 /w:[ 0 ]
  //: joint g60 (w31) @(633, 763) /w:[ 4 6 3 -1 ]
  xor g40 (.I0(w18), .I1(w40), .Z(w30));   //: @(312,763) /sn:0 /w:[ 9 1 1 ]
  mux g54 (.I0(mdr), .I1(w1), .S(w26), .Z(w36));   //: @(790,740) /sn:0 /w:[ 0 0 1 0 ]
  //: joint g81 (_incmar) @(325, 264) /w:[ 4 6 -1 3 ]
  //: frame g93 @(354,466) /sn:0 /wi:421 /ht:164 /tx:"Main Memory"
  concat g46 (.I0(w15), .I1(w31), .Z(w27));   //: @(638,667) /sn:0 /R:1 /w:[ 3 7 1 ] /dr:0
  //: joint g45 (mdrin) @(559, 552) /w:[ 2 4 1 -1 ]
  nor g35 (.I0(!_incpc), .I1(!_ldpc), .Z(w14));   //: @(244,129) /sn:0 /w:[ 0 0 0 ]
  mux g26 (.I0(w9), .I1(DATA), .S(!_ldpc), .Z(w19));   //: @(188,204) /sn:0 /w:[ 0 15 5 0 ]
  //: input g0 (CK) @(60,436) /sn:0 /w:[ 17 ]
  register mar (.Q(mar), .D(w43), .EN(w46), .CLR(_CLR), .CK(CK));   //: @(363,307) /w:[ 0 0 0 17 13 ]
  buf g22 (.I(DATA), .Z(w4));   //: @(574,165) /sn:0 /w:[ 9 0 ]
  nor g70 (.I0(!_ldhmdr), .I1(!_ldmdr), .Z(w));   //: @(874,280) /sn:0 /R:3 /w:[ 3 0 1 ]
  //: comment g90 /dolink:0 /link:"" @(211,844) /sn:0
  //: /line:"This is the tty.  When simulation mode"
  //: /line:"starts, a tty window will be popped up"
  //: /line:"corresponding to this device.  The device"
  //: /line:"may be accessed through the simulated CPU"
  //: /line:"by reading or writing the addresses indicated"
  //: /line:"by the dip switches TTYSTATUS and TTYDATA."
  //: /end
  //: dip TTYDATA (w40) @(174,765) /R:1 /w:[ 0 ] /st:17
  tty tty0 (.TD(TD), .RD(RD), .RTS(RTS), .CTS(CTS), .DSR(DSR), .DTR(DTR));   //: @(414,963) /w:[ 0 1 0 0 0 0 ]
  //: supply0 g66 (w1) @(825,693) /sn:0 /w:[ 1 ]
  //: joint g82 (_incmar) @(325, 281) /w:[ 1 2 -1 8 ]
  //: joint g12 (_rd) @(671, 616) /w:[ 2 1 4 -1 ]
  concat g18 (.I0(mdr), .I1(w3), .Z(w2));   //: @(657,246) /sn:0 /R:2 /w:[ 9 1 0 ] /dr:0
  //: input g33 (_incpc) @(131,126) /sn:0 /w:[ 1 ]
  //: supply0 g30 (w21) @(220,65) /sn:0 /w:[ 0 ]
  //: frame g91 @(45,27) /sn:0 /wi:441 /ht:397 /tx:"Address Resolution"
  //: supply0 g49 (w24) @(595,544) /sn:0 /w:[ 0 ]

endmodule

module REG4(B, _ENA, SB, CK, _ENB, DIN, _WA, _CLR, SA, A);
//: interface  /sz:(107, 138) /bd:[ Ti0>DIN[15:0](52/107) Li0>SA[1:0](17/138) Li1>SB[1:0](33/138) Li2>_CLR(51/138) Li3>_ENA(70/138) Li4>_ENB(88/138) Li5>_WA(106/138) Li6>CK(123/138) Bo0<A[15:0](31/107) Bo1<B[15:0](79/107) ]
output [15:0] B;    //: /sn:0 {0}(507,666)(507,615){1}
input CK;    //: /sn:0 {0}(53,412)(175,412){1}
//: {2}(179,412)(317,412){3}
//: {4}(321,412)(462,412){5}
//: {6}(466,412)(598,412)(598,276)(613,276){7}
//: {8}(464,410)(464,277)(476,277){9}
//: {10}(319,410)(319,281)(326,281){11}
//: {12}(177,410)(177,277)(194,277){13}
input _CLR;    //: /sn:0 {0}(689,271)(701,271)(701,235)(581,235){1}
//: {2}(577,235)(448,235){3}
//: {4}(444,235)(297,235){5}
//: {6}(293,235)(54,235){7}
//: {8}(295,237)(295,272)(270,272){9}
//: {10}(446,237)(446,276)(402,276){11}
//: {12}(579,237)(579,272)(552,272){13}
output [15:0] A;    //: /sn:0 {0}(369,669)(369,616){1}
input _ENA;    //: /sn:0 {0}(51,297)(78,297){1}
//: {2}(82,297)(104,297){3}
//: {4}(80,299)(80,580)(403,580)(403,608)(374,608){5}
input [1:0] SB;    //: /sn:0 {0}(458,543)(484,543){1}
input [1:0] SA;    //: /sn:0 {0}(51,543)(101,543){1}
//: {2}(105,543)(346,543){3}
//: {4}(103,541)(103,340)(121,340){5}
input _ENB;    //: /sn:0 {0}(512,607)(531,607)(531,566)(51,566){1}
input _WA;    //: /sn:0 {0}(52,269)(91,269)(91,292)(104,292){1}
input [15:0] DIN;    //: /sn:0 {0}(650,266)(650,120)(515,120){1}
//: {2}(511,120)(365,120){3}
//: {4}(361,120)(233,120){5}
//: {6}(231,122)(231,267){7}
//: {8}(229,120)(53,120){9}
//: {10}(363,122)(363,271){11}
//: {12}(513,122)(513,267){13}
wire [15:0] w7;    //: /sn:0 {0}(369,556)(369,600){1}
wire [15:0] R2;    //: /sn:0 {0}(375,527)(375,487)(511,487){1}
//: {2}(513,485)(513,288){3}
//: {4}(513,489)(513,527){5}
wire [15:0] R1;    //: /sn:0 {0}(363,527)(363,453){1}
//: {2}(365,451)(501,451)(501,527){3}
//: {4}(363,449)(363,292){5}
wire [15:0] R3;    //: /sn:0 {0}(387,527)(387,505)(523,505){1}
//: {2}(527,505)(650,505)(650,287){3}
//: {4}(525,507)(525,527){5}
wire w2;    //: /sn:0 {0}(125,295)(134,295)(134,316){1}
wire w57;    //: /sn:0 {0}(150,334)(413,334)(413,286)(402,286){1}
wire [15:0] w10;    //: /sn:0 {0}(507,556)(507,599){1}
wire [15:0] R0;    //: /sn:0 {0}(351,527)(351,479){1}
//: {2}(353,477)(489,477)(489,527){3}
//: {4}(349,477)(231,477)(231,288){5}
wire w52;    //: /sn:0 {0}(150,358)(700,358)(700,281)(689,281){1}
wire w47;    //: /sn:0 {0}(150,322)(280,322)(280,282)(270,282){1}
wire w42;    //: /sn:0 {0}(150,346)(565,346)(565,282)(552,282){1}
//: enddecls

  demux g4 (.I(SA), .E(!w2), .Z0(!w47), .Z1(!w57), .Z2(!w42), .Z3(!w52));   //: @(134,340) /sn:0 /R:1 /w:[ 5 1 0 0 0 0 ]
  mux g8 (.I0(R0), .I1(R1), .I2(R2), .I3(R3), .S(SB), .Z(w10));   //: @(507,543) /sn:0 /w:[ 3 3 5 5 1 0 ]
  //: joint g34 (SA) @(103, 543) /w:[ 2 4 1 -1 ]
  mux g13 (.I0(R0), .I1(R1), .I2(R2), .I3(R3), .S(SA), .Z(w7));   //: @(369,543) /sn:0 /w:[ 0 0 0 0 3 0 ]
  //: joint g16 (R2) @(513, 487) /w:[ -1 2 1 4 ]
  //: joint g11 (CK) @(319, 412) /w:[ 4 10 3 -1 ]
  register R2 (.Q(R2), .D(DIN), .EN(w42), .CLR(_CLR), .CK(CK));   //: @(513,277) /w:[ 3 13 1 13 9 ]
  //: joint g28 (_ENA) @(80, 297) /w:[ 2 -1 1 4 ]
  //: joint g10 (CK) @(177, 412) /w:[ 2 12 1 -1 ]
  //: output g32 (B) @(507,663) /sn:0 /R:3 /w:[ 0 ]
  //: input g27 (_ENA) @(49,297) /sn:0 /w:[ 0 ]
  //: input g19 (SB) @(456,543) /sn:0 /w:[ 0 ]
  //: joint g6 (DIN) @(363, 120) /w:[ 4 10 3 -1 ]
  //: joint g7 (DIN) @(513, 120) /w:[ 1 -1 2 12 ]
  //: input g9 (CK) @(51,412) /sn:0 /w:[ 0 ]
  //: input g31 (_ENB) @(49,566) /sn:0 /w:[ 1 ]
  //: input g20 (DIN) @(51,120) /sn:0 /w:[ 9 ]
  //: joint g15 (R1) @(363, 451) /w:[ 2 4 -1 1 ]
  register R1 (.Q(R1), .D(DIN), .EN(w57), .CLR(_CLR), .CK(CK));   //: @(363,281) /w:[ 5 11 1 11 11 ]
  register R3 (.Q(R3), .D(DIN), .EN(w52), .CLR(_CLR), .CK(CK));   //: @(650,276) /w:[ 3 0 1 0 7 ]
  bufif0 g29 (.Z(A), .I(w7), .E(_ENA));   //: @(369,606) /sn:0 /R:3 /w:[ 1 1 5 ]
  //: input g25 (_WA) @(50,269) /sn:0 /w:[ 0 ]
  //: joint g17 (R3) @(525, 505) /w:[ 2 -1 1 4 ]
  //: joint g5 (DIN) @(231, 120) /w:[ 6 8 5 -1 ]
  //: joint g14 (R0) @(351, 477) /w:[ 2 -1 4 1 ]
  //: joint g24 (_CLR) @(579, 235) /w:[ 1 -1 2 12 ]
  //: input g21 (_CLR) @(52,235) /sn:0 /w:[ 7 ]
  //: joint g23 (_CLR) @(446, 235) /w:[ 3 -1 4 10 ]
  register R0 (.Q(R0), .D(DIN), .EN(w47), .CLR(_CLR), .CK(CK));   //: @(231,277) /w:[ 5 7 1 9 13 ]
  or g26 (.I0(_WA), .I1(_ENA), .Z(w2));   //: @(115,295) /sn:0 /w:[ 1 3 0 ]
  //: joint g22 (_CLR) @(295, 235) /w:[ 5 -1 6 8 ]
  //: input g18 (SA) @(49,543) /sn:0 /w:[ 0 ]
  //: joint g12 (CK) @(464, 412) /w:[ 6 8 5 -1 ]
  //: output g33 (A) @(369,666) /sn:0 /R:3 /w:[ 0 ]
  bufif0 g30 (.Z(B), .I(w10), .E(_ENB));   //: @(507,605) /sn:0 /R:3 /w:[ 1 1 0 ]

endmodule

module ALU(A, B, COUT, FUNC, _GT, CIN, _Z, OUT, _LT);
//: interface  /sz:(107, 127) /bd:[ Ti0>B[15:0](79/107) Ti1>A[15:0](31/107) Li0>CIN(95/127) Li1>FUNC[4:0](18/127) Bo0<OUT[15:0](56/107) Ro0<COUT(69/127) Ro1<_LT(52/127) Ro2<_GT(37/127) Ro3<_Z(20/127) ]
input [15:0] B;    //: /sn:0 {0}(258,348)(258,286)(356,286){1}
//: {2}(360,286)(460,286){3}
//: {4}(464,286)(560,286){5}
//: {6}(562,284)(562,184){7}
//: {8}(564,182)(631,182){9}
//: {10}(635,182)(673,182){11}
//: {12}(677,182)(711,182){13}
//: {14}(715,182)(821,182){15}
//: {16}(825,182)(925,182){17}
//: {18}(929,182)(1046,182)(1046,367){19}
//: {20}(927,184)(927,315){21}
//: {22}(823,184)(823,363){23}
//: {24}(713,184)(713,346){25}
//: {26}(675,184)(675,344){27}
//: {28}(633,184)(633,345){29}
//: {30}(560,182)(138,182){31}
//: {32}(562,288)(562,352){33}
//: {34}(462,288)(462,351){35}
//: {36}(358,288)(358,350){37}
output _Z;    //: /sn:0 {0}(876,541)(886,541){1}
//: {2}(890,541)(954,541){3}
//: {4}(888,543)(888,615)(909,615){5}
output _LT;    //: /sn:0 {0}(955,577)(902,577){1}
//: {2}(898,577)(881,577)(881,577)(873,577){3}
//: {4}(900,579)(900,610)(909,610){5}
input CIN;    //: /sn:0 {0}(967,315)(967,286){1}
input [15:0] A;    //: /sn:0 {0}(138,242)(168,242){1}
//: {2}(169,242)(200,242){3}
input [4:0] FUNC;    //: /sn:0 {0}(49,457)(76,457){1}
supply0 [15:0] w1;    //: /sn:0 {0}(148,292)(148,262)(200,262){1}
output _GT;    //: /sn:0 {0}(930,613)(955,613){1}
output [15:0] OUT;    //: /sn:0 {0}(804,646)(804,577){1}
//: {2}(804,576)(804,543){3}
//: {4}(806,541)(855,541){5}
//: {6}(804,539)(804,513){7}
output COUT;    //: /sn:0 {0}(859,328)(859,379)(885,379){1}
wire [15:0] w6;    //: /sn:0 {0}(925,365)(925,336){1}
wire [15:0] w32;    //: /sn:0 {0}(406,436)(406,382)(462,382)(462,372){1}
wire [15:0] w7;    //: /sn:0 {0}(807,484)(807,392){1}
wire [15:0] w16;    //: /sn:0 {0}(793,484)(793,420)(673,420)(673,365){1}
wire [15:0] w15;    //: /sn:0 {0}(787,484)(787,436)(631,436)(631,366){1}
wire w4;    //: /sn:0 {0}(216,229)(216,149)(182,149){1}
wire [1:0] w19;    //: /sn:0 {0}(176,144)(112,144)(112,450){1}
//: {2}(114,452)(377,452){3}
//: {4}(110,452)(82,452){5}
wire w3;    //: /sn:0 {0}(808,577)(857,577){1}
wire [15:0] w31;    //: /sn:0 {0}(394,436)(394,381)(358,381)(358,371){1}
wire [3:0] w18;    //: /sn:0 {0}(169,246)(169,309){1}
//: {2}(171,311)(306,311){3}
//: {4}(310,311)(360,311)(360,311)(413,311){5}
//: {6}(417,311)(512,311)(512,362)(525,362){7}
//: {8}(415,313)(415,361)(425,361){9}
//: {10}(308,313)(308,360)(321,360){11}
//: {12}(169,313)(169,358)(221,358){13}
wire [15:0] w35;    //: /sn:0 {0}(400,465)(400,472)(780,472)(780,484){1}
wire [15:0] w30;    //: /sn:0 {0}(382,436)(382,407)(258,407)(258,369){1}
wire [2:0] w22;    //: /sn:0 {0}(781,500)(92,500)(92,462)(82,462){1}
wire [15:0] w17;    //: /sn:0 {0}(800,484)(800,403)(711,403)(711,367){1}
wire w12;    //: /sn:0 {0}(933,379)(965,379)(965,336){1}
wire [15:0] w11;    //: /sn:0 {0}(820,484)(820,457)(1020,457)(1020,396){1}
wire [15:0] w2;    //: /sn:0 {0}(813,484)(813,443)(909,443)(909,394){1}
wire [15:0] w10;    //: /sn:0 {0}(827,484)(827,474)(1040,474)(1040,396){1}
wire w13;    //: /sn:0 {0}(182,139)(922,139)(922,288){1}
//: {2}(924,290)(962,290)(962,315){3}
//: {4}(922,292)(922,315){5}
wire [15:0] w33;    //: /sn:0 {0}(418,436)(418,420)(562,420)(562,373){1}
wire [15:0] w5;    //: /sn:0 {0}(229,252)(626,252){1}
//: {2}(630,252)(668,252){3}
//: {4}(672,252)(706,252){5}
//: {6}(710,252)(789,252){7}
//: {8}(793,252)(891,252){9}
//: {10}(895,252)(1014,252)(1014,367){11}
//: {12}(893,254)(893,365){13}
//: {14}(791,254)(791,363){15}
//: {16}(708,254)(708,346){17}
//: {18}(670,254)(670,344){19}
//: {20}(628,254)(628,345){21}
//: enddecls

  //: input g4 (A) @(136,242) /sn:0 /w:[ 0 ]
  mux g8 (.I0(A), .I1(w1), .S(w4), .Z(w5));   //: @(216,252) /sn:0 /R:1 /w:[ 3 1 0 0 ]
  //: input g3 (B) @(136,182) /sn:0 /w:[ 31 ]
  //: supply0 g13 (w1) @(148,298) /sn:0 /w:[ 0 ]
  //: joint g34 (w18) @(169, 311) /w:[ 2 1 -1 12 ]
  //: joint g37 (w19) @(112, 452) /w:[ 2 1 4 -1 ]
  //: joint g51 (B) @(358, 286) /w:[ 2 -1 1 36 ]
  div g2 (.A(w5), .B(B), .Q(w10), .R(w11));   //: @(1030,383) /sn:0 /cpc:1 /w:[ 11 19 1 1 ]
  mult g1 (.A(w5), .B(B), .P(w7));   //: @(807,379) /sn:0 /cpc:1 /w:[ 15 23 1 ]
  //: joint g11 (w5) @(708, 252) /w:[ 6 -1 5 16 ]
  xor g16 (.I0(w13), .I1(B), .Z(w6));   //: @(925,326) /sn:0 /R:3 /w:[ 5 21 1 ]
  //: joint g10 (w5) @(791, 252) /w:[ 8 -1 7 14 ]
  roll g28 (.I(B), .Z(w33), .S(w18));   //: @(562,362) /sn:0 /w:[ 33 1 7 ]
  //: joint g50 (B) @(462, 286) /w:[ 4 -1 3 34 ]
  //: output g19 (COUT) @(859,331) /sn:0 /R:1 /w:[ 0 ]
  rshift g27 (.I(B), .Z(w32), .S(w18));   //: @(462,361) /sn:0 /w:[ 35 1 9 ]
  //: joint g32 (B) @(562, 286) /w:[ -1 6 5 32 ]
  and g6 (.I0(w5), .I1(B), .Z(w16));   //: @(673,355) /sn:0 /R:3 /w:[ 19 27 1 ]
  //: input g38 (FUNC) @(47,457) /sn:0 /w:[ 0 ]
  //: joint g53 (w13) @(922, 290) /w:[ 2 1 -1 4 ]
  or g7 (.I0(w5), .I1(B), .Z(w17));   //: @(711,357) /sn:0 /R:3 /w:[ 17 25 1 ]
  //: joint g9 (w5) @(893, 252) /w:[ 10 -1 9 12 ]
  //: joint g15 (B) @(823, 182) /w:[ 16 -1 15 22 ]
  //: joint g20 (B) @(675, 182) /w:[ 12 -1 11 26 ]
  //: joint g31 (w18) @(415, 311) /w:[ 6 -1 5 8 ]
  //: output g39 (_GT) @(952,613) /sn:0 /w:[ 1 ]
  or g43 (.I0(OUT), .Z(_Z));   //: @(866,541) /sn:0 /w:[ 5 0 ]
  //: joint g48 (_Z) @(888, 541) /w:[ 2 -1 1 4 ]
  //: input g17 (CIN) @(967,284) /sn:0 /R:3 /w:[ 1 ]
  arshift g25 (.I(B), .Z(w30), .S(w18));   //: @(258,358) /sn:0 /w:[ 0 1 13 ]
  mux g29 (.I0(w30), .I1(w31), .I2(w32), .I3(w33), .S(w19), .Z(w35));   //: @(400,452) /sn:0 /w:[ 0 0 0 0 3 0 ]
  xor g52 (.I0(w13), .I1(CIN), .Z(w12));   //: @(965,326) /sn:0 /R:3 /w:[ 3 0 1 ]
  //: output g42 (_Z) @(951,541) /sn:0 /w:[ 3 ]
  mux g5 (.I0(w35), .I1(w15), .I2(w16), .I3(w17), .I4(w7), .I5(w2), .I6(w11), .I7(w10), .S(w22), .Z(OUT));   //: @(804,500) /sn:0 /w:[ 1 0 0 0 0 0 0 0 0 7 ]
  //: joint g14 (B) @(927, 182) /w:[ 18 -1 17 20 ]
  //: joint g44 (OUT) @(804, 541) /w:[ 4 6 -1 3 ]
  nand g47 (.I0(_LT), .I1(_Z), .Z(_GT));   //: @(920,613) /sn:0 /w:[ 5 5 0 ]
  xor g21 (.I0(w5), .I1(B), .Z(w15));   //: @(631,356) /sn:0 /R:3 /w:[ 21 29 1 ]
  concat g36 (.I0(w13), .I1(w4), .Z(w19));   //: @(177,144) /sn:0 /R:2 /w:[ 0 1 0 ] /dr:0
  concat g24 (.I0(w19), .I1(w22), .Z(FUNC));   //: @(77,457) /sn:0 /R:2 /w:[ 5 1 1 ] /dr:0
  //: output g41 (OUT) @(804,643) /sn:0 /R:3 /w:[ 0 ]
  //: joint g23 (w5) @(628, 252) /w:[ 2 -1 1 20 ]
  //: output g40 (_LT) @(952,577) /sn:0 /w:[ 0 ]
  add g0 (.A(w5), .B(w6), .S(w2), .CI(w12), .CO(COUT));   //: @(909,381) /sn:0 /w:[ 13 0 1 0 1 ]
  //: joint g22 (B) @(633, 182) /w:[ 10 -1 9 28 ]
  lshift g26 (.I(B), .Z(w31), .S(w18));   //: @(358,360) /sn:0 /w:[ 37 1 11 ]
  //: joint g35 (w18) @(308, 311) /w:[ 4 -1 3 10 ]
  not g45 (.I(w3), .Z(_LT));   //: @(863,577) /sn:0 /w:[ 1 3 ]
  tran g46(.Z(w3), .I(OUT[15]));   //: @(802,577) /sn:0 /R:2 /w:[ 0 1 2 ] /ss:1
  //: joint g18 (B) @(713, 182) /w:[ 14 -1 13 24 ]
  //: joint g12 (w5) @(670, 252) /w:[ 4 -1 3 18 ]
  tran g33(.Z(w18), .I(A[3:0]));   //: @(169,240) /sn:0 /R:1 /w:[ 0 1 2 ] /ss:1
  //: joint g30 (B) @(562, 182) /w:[ 8 -1 30 7 ]
  //: joint g49 (_LT) @(900, 577) /w:[ 1 -1 2 4 ]

endmodule

module IUNIT(CK, _LDQ, _WA, _rd, _DOUT, _rdmdr, _CLQ, FUNC, _CLR, _LDQH, SB, _ldmdr, IR, _ldmar, _incmar, _LDQL, SA, IDATA, _incpc, _LDDATA, COUT, _LT, _Z, spc, _ldpc, _wrt, _ldhmdr, _GT, AOP, BOP, _rdpc, CIN);
//: interface  /sz:(132, 353) /bd:[ Ti0>CK(37/132) Ti1>_CLR(86/132) Li0>_incmar(187/353) Bi0>IR[15:0](62/132) Ri0>_LT(258/353) Ri1>_GT(276/353) Ri2>_Z(296/353) Ri3>COUT(314/353) Lo0<_wrt(105/353) Lo1<_rdmdr(89/353) Lo2<_incpc(74/353) Lo3<_ldmdr(58/353) Lo4<_ldmar(43/353) Lo5<_ldpc(26/353) Lo6<_ldhmdr(156/353) Lo7<spc(137/353) Lo8<_rd(121/353) Ro0<SA[3:0](18/353) Ro1<SB[3:0](33/353) Ro2<_WA(50/353) Ro3<AOP[1:0](65/353) Ro4<BOP[1:0](81/353) Ro5<FUNC[4:0](95/353) Ro6<IDATA[7:0](113/353) Ro7<_CLQ(133/353) Ro8<_LDQ(150/353) Ro9<CIN(165/353) Ro10<_LDDATA(182/353) Ro11<_LDQH(200/353) Ro12<_LDQL(220/353) Ro13<_DOUT(239/353) Lt0=_rdpc(172/353) ]
input _Z;    //: /sn:0 {0}(1162,361)(1137,361)(1137,358)(1115,358){1}
input [15:0] IR;    //: /sn:0 {0}(59,70)(84,70){1}
output _CLQ;    //: /sn:0 {0}(693,714)(488,714){1}
output _rdpc;    //: /sn:0 {0}(494,1167)(704,1167){1}
output _rd;    //: /sn:0 {0}(494,1037)(704,1037){1}
input _LT;    //: /sn:0 {0}(1166,345)(1156,345)(1156,348)(1115,348){1}
supply0 [7:0] w15;    //: /sn:0 {0}(205,673)(205,717){1}
supply1 w19;    //: /sn:0 {0}(424,671)(424,662)(410,662)(410,649){1}
input CK;    //: /sn:0 /dp:21 {0}(436,1125)(436,1148)(264,1148)(264,773){1}
//: {2}(266,771)(429,771)(429,747){3}
//: {4}(264,769)(264,513){5}
//: {6}(266,511)(294,511){7}
//: {8}(262,511)(104,511){9}
//: {10}(102,509)(102,278){11}
//: {12}(104,276)(1069,276)(1069,315){13}
//: {14}(102,274)(102,122){15}
//: {16}(104,120)(233,120)(233,98)(243,98){17}
//: {18}(102,118)(102,98)(114,98){19}
//: {20}(100,511)(83,511){21}
output _LDQH;    //: /sn:0 {0}(494,1127)(704,1127){1}
output CIN;    //: /sn:0 {0}(693,704)(488,704){1}
input _CLR;    //: /sn:0 {0}(370,506)(525,506)(525,76){1}
//: {2}(527,74)(666,74)(666,460)(1074,460)(1074,391){3}
//: {4}(525,72)(525,63){5}
//: {6}(523,74)(387,74){7}
//: {8}(383,74)(201,74)(201,93)(190,93){9}
//: {10}(385,76)(385,93)(319,93){11}
output _ldmar;    //: /sn:0 {0}(494,1007)(704,1007){1}
output _ldhmdr;    //: /sn:0 {0}(704,1157)(494,1157){1}
output _wrt;    //: /sn:0 {0}(494,1057)(704,1057){1}
supply1 w21;    //: /sn:0 {0}(175,641)(175,659)(197,659){1}
output [4:0] FUNC;    //: /sn:0 {0}(769,956)(738,956){1}
output _ldpc;    //: /sn:0 {0}(494,1027)(704,1027){1}
supply0 w28;    //: /sn:0 {0}(839,352)(839,334)(813,334){1}
supply1 w24;    //: /sn:0 {0}(431,1049)(431,1036)(410,1036)(410,1016){1}
supply0 w20;    //: /sn:0 {0}(441,1049)(441,1025)(455,1025)(455,1036){1}
output [3:0] SB;    //: /sn:0 {0}(769,890)(738,890){1}
supply0 [7:0] w23;    //: /sn:0 {0}(360,361)(360,341)(325,341)(325,401){1}
output _LDDATA;    //: /sn:0 {0}(693,734)(488,734){1}
output [1:0] AOP;    //: /sn:0 {0}(488,684)(693,684){1}
output _LDQ;    //: /sn:0 {0}(693,724)(488,724){1}
output _rdmdr;    //: /sn:0 {0}(494,1047)(704,1047){1}
output [3:0] SA;    //: /sn:0 {0}(738,818)(769,818){1}
output _WA;    //: /sn:0 {0}(693,754)(488,754){1}
output _DOUT;    //: /sn:0 {0}(704,1137)(494,1137){1}
output _incpc;    //: /sn:0 {0}(494,997)(704,997){1}
supply0 w30;    //: /sn:0 {0}(434,671)(434,662)(455,662)(455,672){1}
output spc;    //: /sn:0 {0}(494,1067)(704,1067){1}
output _ldmdr;    //: /sn:0 {0}(704,1017)(494,1017){1}
supply0 w2;    //: /sn:0 {0}(199,416)(199,395){1}
supply0 w11;    //: /sn:0 {0}(372,1125)(372,1114){1}
output _incmar;    //: /sn:0 {0}(704,1177)(494,1177){1}
output [1:0] BOP;    //: /sn:0 {0}(488,694)(693,694){1}
output _LDQL;    //: /sn:0 {0}(494,1117)(704,1117){1}
supply0 w5;    //: /sn:0 {0}(368,745)(368,736){1}
input _GT;    //: /sn:0 {0}(1163,323)(1125,323)(1125,338)(1115,338){1}
supply0 w9;    //: /sn:0 {0}(380,528)(380,516)(370,516){1}
output [7:0] IDATA;    //: /sn:0 {0}(409,380)(540,380)(540,652){1}
//: {2}(542,654)(693,654){3}
//: {4}(538,654)(488,654){5}
input COUT;    //: /sn:0 {0}(1115,368)(1139,368)(1139,375)(1161,375){1}
wire w32;    //: /sn:0 {0}(901,386)(935,386){1}
//: {2}(939,386)(953,386)(953,368)(1025,368){3}
//: {4}(937,384)(937,314)(813,314){5}
wire [7:0] w6;    //: /sn:0 {0}(90,65)(149,65){1}
//: {2}(153,65)(280,65)(280,88){3}
//: {4}(151,67)(151,88){5}
wire [7:0] mp_nxtaddr;    //: /sn:0 {0}(354,1087)(331,1087)(331,733){1}
//: {2}(331,729)(331,711){3}
//: {4}(333,709)(350,709){5}
//: {6}(331,707)(331,522){7}
//: {8}(329,731)(237,731)(237,673){9}
wire [3:0] w45;    //: /sn:0 {0}(709,880)(601,880)(601,173)(325,173){1}
wire [4:0] w7;    //: /sn:0 {0}(325,192)(591,192)(591,946)(709,946){1}
wire ww;    //: /sn:0 {0}(891,358)(943,358){1}
//: {2}(947,358)(1000,358)(1000,358)(1025,358){3}
//: {4}(945,356)(945,307)(813,307){5}
wire [3:0] w46;    //: /sn:0 {0}(709,900)(568,900)(568,774)(488,774){1}
wire [1:0] w14;    //: /sn:0 {0}(488,644)(517,644)(517,455)(281,455)(281,417)(308,417){1}
wire _ldir;    //: /sn:0 {0}(488,674)(554,674)(554,113)(216,113)(216,103)(190,103){1}
wire w4;    //: /sn:0 {0}(813,294)(999,294)(999,338)(1025,338){1}
wire [2:0] w38;    //: /sn:0 {0}(325,241)(621,241)(621,443)(787,443)(787,429){1}
wire _SA;    //: /sn:0 {0}(870,356)(863,356)(863,320)(813,320){1}
wire [3:0] w3;    //: /sn:0 {0}(1058,353)(1031,353){1}
wire [7:0] OPR;    //: /sn:0 {0}(280,131)(280,109){1}
wire w0;    //: /sn:0 {0}(494,1147)(1064,1147)(1064,391){1}
wire [1:0] w37;    //: /sn:0 {0}(335,224)(325,224){1}
wire [31:0] mp_wrd0;    //: /sn:0 {0}(439,709)(482,709){1}
wire w43;    //: /sn:0 {0}(725,795)(725,780)(535,780)(535,1077)(494,1077){1}
wire [7:0] IRR;    //: /sn:0 {0}(151,131)(151,109){1}
wire [3:0] w41;    //: /sn:0 {0}(709,808)(610,808)(610,153)(325,153){1}
wire [7:0] w36;    //: /sn:0 {0}(181,368)(162,368)(162,259){1}
wire [7:0] w1;    //: /sn:0 {0}(337,401)(337,368)(216,368){1}
wire [7:0] w25;    //: /sn:0 {0}(100,75)(90,75){1}
wire _ldopr;    //: /sn:0 {0}(488,744)(570,744)(570,103)(319,103){1}
wire [31:0] w8;    //: /sn:0 {0}(488,1087)(446,1087){1}
wire w40;    //: /sn:0 {0}(820,413)(835,413)(835,1107)(494,1107){1}
wire w35;    //: /sn:0 {0}(784,311)(692,311)(692,433)(393,433)(393,413){1}
wire [2:0] w18;    //: /sn:0 {0}(488,664)(807,664)(807,429){1}
wire w22;    //: /sn:0 {0}(245,659)(255,659){1}
wire _SA0;    //: /sn:0 {0}(880,384)(850,384)(850,327)(813,327){1}
wire [4:0] w49;    //: /sn:0 {0}(494,987)(601,987)(601,966)(709,966){1}
wire [2:0] w44;    //: /sn:0 {0}(797,334)(797,400){1}
wire [7:0] w12;    //: /sn:0 {0}(380,390)(349,390)(349,401){1}
wire [31:0] w10;    //: /sn:0 {0}(425,1087)(389,1087){1}
wire [7:0] w13;    //: /sn:0 {0}(331,430)(331,501){1}
wire [7:0] w27;    //: /sn:0 {0}(409,400)(419,400)(419,480)(223,480){1}
//: {2}(221,478)(221,395)(313,395)(313,401){3}
//: {4}(221,482)(221,644){5}
wire [3:0] w48;    //: /sn:0 {0}(1109,353)(1079,353){1}
wire [1:0] w33;    //: /sn:0 {0}(335,208)(325,208){1}
wire w47;    //: /sn:0 {0}(725,867)(725,853)(545,853)(545,1087)(494,1087){1}
wire w42;    //: /sn:0 {0}(725,933)(725,921)(557,921)(557,1097)(494,1097){1}
wire [7:0] extra;    //: /dp:1 {0}(494,1187)(504,1187)(504,1234)(446,1234){1}
wire w55;    //: /sn:0 {0}(1025,348)(951,348)(951,333){1}
//: {2}(951,329)(951,300)(881,300){3}
//: {4}(879,298)(879,287)(813,287){5}
//: {6}(877,300)(813,300){7}
//: {8}(949,331)(911,331)(911,351){9}
//: {10}(909,353)(891,353){11}
//: {12}(911,355)(911,381)(901,381){13}
wire [3:0] w39;    //: /sn:0 {0}(488,764)(577,764)(577,828)(709,828){1}
wire [31:0] w26;    //: /sn:0 {0}(418,709)(385,709){1}
//: enddecls

  //: supply0 g8 (w11) @(372,1131) /sn:0 /w:[ 0 ]
  nor g4 (.I0(!w55), .I1(!ww), .Z(_SA));   //: @(880,356) /sn:0 /R:2 /w:[ 11 0 0 ]
  //: comment g61 /dolink:0 /link:"" @(366,789)
  //: /line:"This is the low half"
  //: /line:"of the microinstruction"
  //: /line:"memory."
  //: /end
  //: joint g37 (CK) @(264, 511) /w:[ 6 -1 8 5 ]
  //: frame g86 @(741,228) /sn:0 /wi:482 /ht:251 /tx:"Condition Code Handling"
  //: joint g13 (mp_nxtaddr) @(331, 731) /w:[ -1 2 8 1 ]
  //: input g3 (CK) @(81,511) /sn:0 /w:[ 21 ]
  register g34 (.Q(mp_wrd0), .D(w26), .EN(w30), .CLR(w19), .CK(CK));   //: @(429,709) /sn:0 /R:1 /w:[ 0 0 0 0 3 ]
  //: output g51 (_LDQ) @(690,724) /sn:0 /w:[ 0 ]
  //: output g55 (_WA) @(690,754) /sn:0 /w:[ 0 ]
  //: output g58 (_rd) @(701,1037) /sn:0 /w:[ 1 ]
  register IR (.Q(IRR), .D(w6), .EN(_ldir), .CLR(_CLR), .CK(CK));   //: @(151,98) /w:[ 1 5 1 9 19 ]
  register g77 (.Q(w3), .D(w48), .EN(w0), .CLR(_CLR), .CK(CK));   //: @(1069,353) /sn:0 /R:3 /w:[ 0 1 1 3 13 ]
  //: supply0 g2 (w9) @(380,534) /sn:0 /w:[ 0 ]
  //: output g76 (_DOUT) @(701,1137) /sn:0 /w:[ 0 ]
  //: comment g65 /dolink:0 /link:"" @(101,14)
  //: /line:"The IR and OPR registers store the"
  //: /line:"instruction and operand bytes of "
  //: /line:"the current instruction. "
  //: /end
  //: output g59 (_rdmdr) @(701,1047) /sn:0 /w:[ 1 ]
  mux g72 (.I0(w38), .I1(w18), .S(w40), .Z(w44));   //: @(797,413) /sn:0 /R:2 /w:[ 1 1 0 1 ]
  //: joint g1 (w27) @(221, 480) /w:[ 1 2 -1 4 ]
  rom map (.A(w36), .D(w1), .OE(w2));   //: @(199,369) /w:[ 0 1 1 ]
  //: supply0 g16 (w2) @(199,422) /sn:0 /w:[ 0 ]
  concat g11 (.I0(w49), .I1(_incpc), .I2(_ldmar), .I3(_ldmdr), .I4(_ldpc), .I5(_rd), .I6(_rdmdr), .I7(_wrt), .I8(spc), .I9(w43), .I10(w47), .I11(w42), .I12(w40), .I13(_LDQL), .I14(_LDQH), .I15(_DOUT), .I16(w0), .I17(_ldhmdr), .I18(_rdpc), .I19(_incmar), .I20(extra), .Z(w8));   //: @(489,1087) /sn:0 /R:2 /w:[ 0 0 0 1 0 0 0 0 0 1 1 1 1 0 0 1 0 1 0 1 0 0 ] /dr:0
  register OPR (.Q(OPR), .D(w6), .EN(_ldopr), .CLR(_CLR), .CK(CK));   //: @(280,98) /w:[ 1 3 1 11 17 ]
  rom m2 (.A(mp_nxtaddr), .D(w10), .OE(w11));   //: @(372,1088) /w:[ 0 1 1 ]
  register mpc (.Q(mp_nxtaddr), .D(w13), .EN(w9), .CLR(_CLR), .CK(CK));   //: @(331,511) /w:[ 7 1 1 0 7 ]
  //: frame g87 @(26,611) /sn:0 /wi:827 /ht:641 /tx:"Microinstruction Decode"
  concat g78 (.I0(_GT), .I1(_LT), .I2(_Z), .I3(COUT), .Z(w48));   //: @(1110,353) /sn:0 /R:2 /w:[ 1 1 1 0 0 ] /dr:0
  mux g10 (.I0(w27), .I1(w23), .I2(w1), .I3(w12), .S(w14), .Z(w13));   //: @(331,417) /sn:0 /w:[ 3 1 0 1 1 0 ]
  //: output g50 (_CLQ) @(690,714) /sn:0 /w:[ 0 ]
  //: output g28 (FUNC) @(766,956) /sn:0 /w:[ 0 ]
  //: joint g27 (w32) @(937, 386) /w:[ 2 4 1 -1 ]
  //: joint g32 (w55) @(951, 331) /w:[ -1 2 8 1 ]
  //: supply0 g19 (w28) @(839,358) /sn:0 /w:[ 0 ]
  rom m1 (.A(mp_nxtaddr), .D(w26), .OE(w5));   //: @(368,710) /w:[ 5 1 1 ]
  //: input g69 (_CLR) @(525,61) /sn:0 /R:3 /w:[ 5 ]
  //: joint g6 (_CLR) @(525, 74) /w:[ 2 4 6 1 ]
  OPRDEC g38 (.OPR(OPR), .IR(IRR), .MAP(w36), .OM1(w33), .COND(w38), .OM2(w37), .FUNC(w7), .SB(w45), .SA(w41));   //: @(132, 132) /sz:(192, 126) /sn:0 /p:[ Ti0>0 Ti1>0 Bo0<1 Ro0<1 Ro1<0 Ro2<1 Ro3<0 Ro4<1 Ro5<1 ]
  //: output g75 (_LDQH) @(701,1127) /sn:0 /w:[ 1 ]
  //: supply0 g9 (w5) @(368,751) /sn:0 /w:[ 0 ]
  //: output g57 (SB) @(766,890) /sn:0 /w:[ 0 ]
  //: output g53 (_ldmdr) @(701,1017) /sn:0 /w:[ 0 ]
  //: joint g7 (CK) @(102, 120) /w:[ 16 18 -1 15 ]
  mux g71 (.I0(w45), .I1(w46), .S(w47), .Z(SB));   //: @(725,890) /sn:0 /R:1 /w:[ 0 0 0 1 ]
  //: supply0 g15 (w15) @(205,723) /sn:0 /w:[ 1 ]
  mux g20 (.I0(IDATA), .I1(w27), .S(w35), .Z(w12));   //: @(393,390) /sn:0 /R:3 /w:[ 0 0 1 0 ]
  //: input g31 (IR) @(57,70) /sn:0 /w:[ 0 ]
  mux g68 (.I0(w41), .I1(w39), .S(w43), .Z(SA));   //: @(725,818) /sn:0 /R:1 /w:[ 0 1 0 0 ]
  //: supply1 g39 (w19) @(421,649) /sn:0 /w:[ 1 ]
  //: joint g67 (w6) @(151, 65) /w:[ 2 -1 1 4 ]
  //: supply0 g43 (w20) @(455,1042) /sn:0 /w:[ 1 ]
  //: joint g48 (IDATA) @(540, 654) /w:[ 2 1 4 -1 ]
  //: frame g88 @(176,317) /sn:0 /wi:311 /ht:239 /tx:"Microcode Next Address Generation"
  //: joint g29 (ww) @(945, 358) /w:[ 2 4 1 -1 ]
  mux g73 (.I0(w7), .I1(w49), .S(w42), .Z(FUNC));   //: @(725,956) /sn:0 /R:1 /w:[ 1 1 0 1 ]
  nor g25 (.I0(!w55), .I1(!w32), .Z(_SA0));   //: @(890,384) /sn:0 /R:2 /w:[ 13 0 0 ]
  //: supply0 g17 (w23) @(360,367) /sn:0 /w:[ 0 ]
  //: comment g62 /dolink:0 /link:"" @(370,940)
  //: /line:"This is the high half"
  //: /line:"of the microinstruction"
  //: /line:"memory."
  //: /end
  //: joint g63 (CK) @(264, 771) /w:[ 2 4 -1 1 ]
  //: supply0 g42 (w30) @(455,678) /sn:0 /w:[ 1 ]
  //: output g52 (_ldmar) @(701,1007) /sn:0 /w:[ 1 ]
  //: output g83 (_incmar) @(701,1177) /sn:0 /w:[ 0 ]
  //: output g74 (_LDQL) @(701,1117) /sn:0 /w:[ 1 ]
  //: output g56 (SA) @(766,818) /sn:0 /w:[ 1 ]
  //: joint g5 (mp_nxtaddr) @(331, 709) /w:[ 4 6 -1 3 ]
  //: supply1 g14 (w21) @(186,641) /sn:0 /w:[ 0 ]
  //: joint g80 (CK) @(102, 276) /w:[ 12 14 -1 11 ]
  concat g79 (.I0(w32), .I1(ww), .I2(w55), .I3(w4), .Z(w3));   //: @(1030,353) /sn:0 /w:[ 3 3 0 1 1 ] /dr:0
  //: output g47 (IDATA) @(690,654) /sn:0 /w:[ 3 ]
  //: output g44 (_incpc) @(701,997) /sn:0 /w:[ 1 ]
  //: comment g85 /dolink:0 /link:"" @(16,131) /sn:0
  //: /line:"This block"
  //: /line:"decodes"
  //: /line:"insructions"
  //: /line:"producing"
  //: /line:"a map index,"
  //: /line:"register"
  //: /line:"numbers,"
  //: /line:"a function"
  //: /line:"code and a"
  //: /line:"condition"
  //: /line:"code."
  //: /end
  //: output g36 (_LDDATA) @(690,734) /sn:0 /w:[ 0 ]
  //: input g21 (COUT) @(1163,375) /sn:0 /R:2 /w:[ 1 ]
  //: input g24 (_LT) @(1168,345) /sn:0 /R:2 /w:[ 0 ]
  //: comment g84 /dolink:0 /link:"" @(694,22)
  //: /line:"This is a trival example of an"
  //: /line:"instruction unit.  The mpc register"
  //: /line:"contains the micro-instruction"
  //: /line:"program counter, and the two"
  //: /line:"registers on the data out of ROMs"
  //: /line:"m1 and m2 are the current micro-"
  //: /line:"instructions.  Note that since these"
  //: /line:"are two separate registers the a"
  //: /line:"single cycle jump delay."
  //: /end
  //: input g23 (_Z) @(1164,361) /sn:0 /R:2 /w:[ 0 ]
  //: output g41 (spc) @(701,1067) /sn:0 /w:[ 1 ]
  //: supply1 g40 (w24) @(421,1016) /sn:0 /w:[ 1 ]
  //: output g54 (_ldpc) @(701,1027) /sn:0 /w:[ 1 ]
  //: output g60 (_wrt) @(701,1057) /sn:0 /w:[ 1 ]
  //: output g81 (_ldhmdr) @(701,1157) /sn:0 /w:[ 0 ]
  //: joint g22 (w55) @(879, 300) /w:[ 3 4 6 -1 ]
  concat g0 (.I0(w14), .I1(IDATA), .I2(w18), .I3(_ldir), .I4(AOP), .I5(BOP), .I6(CIN), .I7(_CLQ), .I8(_LDQ), .I9(_LDDATA), .I10(_ldopr), .I11(_WA), .I12(w39), .I13(w46), .Z(mp_wrd0));   //: @(483,709) /sn:0 /R:2 /w:[ 0 5 0 0 0 0 1 1 1 1 0 1 0 1 1 ] /dr:0
  //: input g26 (_GT) @(1165,323) /sn:0 /R:2 /w:[ 0 ]
  register g35 (.Q(w8), .D(w10), .EN(w20), .CLR(w24), .CK(CK));   //: @(436,1087) /sn:0 /R:1 /w:[ 1 0 0 0 0 ]
  //: output g45 (AOP) @(690,684) /sn:0 /w:[ 1 ]
  //: output g46 (BOP) @(690,694) /sn:0 /w:[ 1 ]
  //: joint g70 (_CLR) @(385, 74) /w:[ 7 -1 8 10 ]
  //: output g82 (_rdpc) @(701,1167) /sn:0 /w:[ 1 ]
  concat g66 (.I0(w6), .I1(w25), .Z(IR));   //: @(85,70) /sn:0 /R:2 /w:[ 0 1 1 ] /dr:0
  add g12 (.A(mp_nxtaddr), .B(w15), .S(w27), .CI(w21), .CO(w22));   //: @(221,657) /sn:0 /R:2 /w:[ 9 0 5 1 0 ]
  mux g18 (.I0(!w55), .I1(!w4), .I2(w55), .I3(ww), .I4(w32), .I5(_SA), .I6(_SA0), .I7(w28), .S(w44), .Z(w35));   //: @(797,311) /sn:0 /R:3 /w:[ 5 0 7 5 5 1 1 1 0 0 ]
  //: joint g30 (CK) @(102, 511) /w:[ 9 10 20 -1 ]
  //: joint g33 (w55) @(911, 353) /w:[ -1 9 10 12 ]
  //: output g49 (CIN) @(690,704) /sn:0 /w:[ 0 ]

endmodule

module ZREG4(CK, SB, _ENA, B, DIN, _ENB, _WA, _CLR, SA, A);
//: interface  /sz:(107, 138) /bd:[ Ti0>DIN[15:0](52/107) Li0>SA[1:0](17/138) Li1>SB[1:0](33/138) Li2>_CLR(51/138) Li3>_ENA(70/138) Li4>_ENB(88/138) Li5>_WA(106/138) Li6>CK(123/138) Bo0<A[15:0](31/107) Bo1<B[15:0](79/107) ]
output [15:0] B;    //: /sn:0 {0}(507,666)(507,615){1}
input CK;    //: /sn:0 {0}(46,421)(314,421){1}
//: {2}(318,421)(463,421){3}
//: {4}(467,421)(578,421)(578,285)(612,285){5}
//: {6}(465,419)(465,279)(476,279){7}
//: {8}(316,419)(316,283)(326,283){9}
input _CLR;    //: /sn:0 {0}(552,274)(560,274)(560,237){1}
//: {2}(562,235)(703,235)(703,280)(688,280){3}
//: {4}(558,235)(414,235){5}
//: {6}(410,235)(367,235)(367,235)(54,235){7}
//: {8}(412,237)(412,278)(402,278){9}
supply0 [15:0] w0;    //: /sn:0 {0}(282,505)(282,477)(349,477){1}
//: {2}(353,477)(489,477)(489,527){3}
//: {4}(351,479)(351,527){5}
output [15:0] A;    //: /sn:0 {0}(369,669)(369,616){1}
input _ENA;    //: /sn:0 {0}(51,297)(78,297){1}
//: {2}(82,297)(104,297){3}
//: {4}(80,299)(80,586)(384,586)(384,608)(374,608){5}
input [1:0] SB;    //: /sn:0 {0}(458,543)(484,543){1}
input [1:0] SA;    //: /sn:0 {0}(51,543)(101,543){1}
//: {2}(105,543)(346,543){3}
//: {4}(103,541)(103,340)(121,340){5}
input _ENB;    //: /sn:0 {0}(512,607)(531,607)(531,566)(51,566){1}
input _WA;    //: /sn:0 {0}(52,269)(91,269)(91,292)(104,292){1}
input [15:0] DIN;    //: /sn:0 {0}(513,269)(513,122){1}
//: {2}(515,120)(649,120)(649,275){3}
//: {4}(511,120)(365,120){5}
//: {6}(361,120)(53,120){7}
//: {8}(363,122)(363,273){9}
wire w6;    //: /sn:0 {0}(552,284)(563,284)(563,346)(150,346){1}
wire [15:0] w81;    //: /sn:0 {0}(507,556)(507,599){1}
wire w19;    //: /sn:0 {0}(125,295)(134,295)(134,316){1}
wire w3;    //: /sn:0 {0}(402,288)(423,288)(423,334)(150,334){1}
wire [15:0] R2;    //: /sn:0 {0}(513,290)(513,485){1}
//: {2}(511,487)(375,487)(375,527){3}
//: {4}(513,489)(513,527){5}
wire w34;    //: /sn:0 {0}(150,358)(702,358)(702,290)(688,290){1}
wire w31;    //: /sn:0 {0}(150,322)(162,322){1}
wire [15:0] R1;    //: /sn:0 {0}(363,294)(363,449){1}
//: {2}(365,451)(501,451)(501,527){3}
//: {4}(363,453)(363,527){5}
wire [15:0] R3;    //: /sn:0 {0}(649,296)(649,505)(527,505){1}
//: {2}(523,505)(387,505)(387,527){3}
//: {4}(525,507)(525,527){5}
wire [15:0] w65;    //: /sn:0 {0}(369,556)(369,600){1}
//: enddecls

  mux g8 (.I0(w0), .I1(R1), .I2(R2), .I3(R3), .S(SB), .Z(w81));   //: @(507,543) /sn:0 /w:[ 3 3 5 5 1 0 ]
  demux g4 (.I(SA), .E(!w19), .Z0(!w31), .Z1(!w3), .Z2(!w6), .Z3(!w34));   //: @(134,340) /sn:0 /R:1 /w:[ 5 1 0 1 1 0 ]
  mux g13 (.I0(w0), .I1(R1), .I2(R2), .I3(R3), .S(SA), .Z(w65));   //: @(369,543) /sn:0 /w:[ 5 5 3 3 3 0 ]
  //: joint g34 (SA) @(103, 543) /w:[ 2 1 4 -1 ]
  //: input g2 (CK) @(44,421) /sn:0 /w:[ 0 ]
  //: joint g1 (w0) @(351, 477) /w:[ 2 -1 1 4 ]
  //: comment g16 /dolink:0 /link:"" @(157,445) /sn:0
  //: /line:"Register R0 is hard-coded"
  //: /line:"to always be set to 0."
  //: /end
  register R2 (.Q(R2), .D(DIN), .EN(w6), .CLR(_CLR), .CK(CK));   //: @(513,279) /w:[ 0 0 0 0 7 ]
  //: joint g11 (R3) @(525, 505) /w:[ 1 -1 2 4 ]
  //: joint g28 (_ENA) @(80, 297) /w:[ 2 -1 1 4 ]
  //: joint g10 (R2) @(513, 487) /w:[ -1 1 2 4 ]
  //: input g19 (SB) @(456,543) /sn:0 /w:[ 0 ]
  //: input g27 (_ENA) @(49,297) /sn:0 /w:[ 0 ]
  //: output g32 (B) @(507,663) /sn:0 /R:3 /w:[ 0 ]
  //: joint g6 (DIN) @(363, 120) /w:[ 5 -1 6 8 ]
  //: joint g9 (_CLR) @(412, 235) /w:[ 5 -1 6 8 ]
  //: joint g7 (DIN) @(513, 120) /w:[ 2 -1 4 1 ]
  //: input g20 (DIN) @(51,120) /sn:0 /w:[ 7 ]
  //: input g31 (_ENB) @(49,566) /sn:0 /w:[ 1 ]
  //: joint g15 (CK) @(465, 421) /w:[ 4 6 3 -1 ]
  register R1 (.Q(R1), .D(DIN), .EN(w3), .CLR(_CLR), .CK(CK));   //: @(363,283) /w:[ 0 9 0 9 9 ]
  register R3 (.Q(R3), .D(DIN), .EN(w34), .CLR(_CLR), .CK(CK));   //: @(649,285) /w:[ 0 3 1 3 5 ]
  //: input g25 (_WA) @(50,269) /sn:0 /w:[ 0 ]
  bufif0 g29 (.Z(A), .I(w65), .E(_ENA));   //: @(369,606) /sn:0 /R:3 /w:[ 1 1 5 ]
  //: joint g5 (R1) @(363, 451) /w:[ 2 1 -1 4 ]
  //: joint g14 (CK) @(316, 421) /w:[ 2 8 1 -1 ]
  //: input g21 (_CLR) @(52,235) /sn:0 /w:[ 7 ]
  //: supply0 g0 (w0) @(282,511) /sn:0 /w:[ 0 ]
  or g26 (.I0(_WA), .I1(_ENA), .Z(w19));   //: @(115,295) /sn:0 /w:[ 1 3 0 ]
  //: input g18 (SA) @(49,543) /sn:0 /w:[ 0 ]
  //: joint g12 (_CLR) @(560, 235) /w:[ 2 -1 4 1 ]
  bufif0 g30 (.Z(B), .I(w81), .E(_ENB));   //: @(507,605) /sn:0 /R:3 /w:[ 1 1 0 ]
  //: output g33 (A) @(369,666) /sn:0 /R:3 /w:[ 0 ]

endmodule

module OPRDEC(SB, SA, FUNC, OPR, OM2, MAP, OM1, COND, IR);
//: interface  /sz:(192, 126) /bd:[ Ti0>IR[7:0](19/192) Ti1>OPR[7:0](148/192) Bo0<MAP[7:0](23/192) Ro0<SA[3:0](21/126) Ro1<SB[3:0](41/126) Ro2<FUNC[4:0](60/126) Ro3<OM2[1:0](92/126) Ro4<COND[2:0](109/126) Ro5<OM1[1:0](76/126) ]
input [7:0] IR;    //: /sn:0 {0}(569,291)(430,291){1}
//: {2}(429,291)(382,291){3}
//: {4}(381,291)(356,291){5}
//: {6}(355,291)(323,291){7}
//: {8}(322,291)(251,291){9}
//: {10}(250,291)(219,291){11}
//: {12}(218,291)(196,291){13}
//: {14}(195,291)(167,291){15}
//: {16}(166,291)(150,291){17}
supply1 [2:0] w19;    //: /sn:0 {0}(279,445)(234,445)(234,431){1}
input [7:0] OPR;    //: /sn:0 {0}(397,114)(352,114){1}
output [4:0] FUNC;    //: /sn:0 {0}(640,228)(505,228){1}
output [7:0] MAP;    //: /sn:0 {0}(590,294)(643,294){1}
output [3:0] SB;    //: /sn:0 {0}(493,90)(441,90)(441,109)(403,109){1}
output [1:0] OM1;    //: /sn:0 {0}(511,187)(642,187){1}
output [3:0] SA;    //: /sn:0 {0}(403,119)(445,119)(445,141)(489,141){1}
supply1 [1:0] w22;    //: /sn:0 {0}(385,412)(385,453)(446,453){1}
output [2:0] COND;    //: /sn:0 {0}(640,261)(506,261){1}
supply1 [2:0] w13;    //: /sn:0 {0}(422,411)(422,433)(446,433){1}
output [1:0] OM2;    //: /sn:0 {0}(572,517)(646,517){1}
wire w16;    //: /sn:0 {0}(458,489)(474,489)(474,512)(566,512){1}
wire [3:0] w14;    //: /sn:0 {0}(251,286)(251,184)(276,184){1}
wire [2:0] w4;    //: /sn:0 {0}(430,286)(430,261)(490,261){1}
wire w15;    //: /sn:0 {0}(297,184)(490,184){1}
wire w24;    //: /sn:0 {0}(219,295)(219,400)(237,400){1}
wire [2:0] w23;    //: /sn:0 {0}(300,443)(446,443){1}
wire [7:0] w20;    //: /sn:0 {0}(452,443)(550,443)(550,296)(569,296){1}
wire [4:0] w1;    //: /sn:0 {0}(382,286)(382,228)(489,228){1}
wire w25;    //: /sn:0 {0}(258,404)(271,404)(271,440)(279,440){1}
wire [1:0] w18;    //: /sn:0 {0}(356,295)(356,517)(392,517){1}
wire w8;    //: /sn:0 /dp:1 {0}(237,404)(167,404)(167,295){1}
wire w17;    //: /sn:0 {0}(437,486)(196,486)(196,409){1}
//: {2}(198,407)(237,407){3}
//: {4}(196,405)(196,295){5}
wire w11;    //: /sn:0 {0}(566,522)(398,522){1}
wire [1:0] w10;    //: /sn:0 {0}(323,286)(323,189)(490,189){1}
wire w26;    //: /sn:0 {0}(398,512)(420,512)(420,491)(437,491){1}
//: enddecls

  //: output g4 (SB) @(490,90) /sn:0 /w:[ 0 ]
  //: supply1 g34 (w19) @(245,431) /sn:0 /w:[ 1 ]
  //: output g3 (SA) @(486,141) /sn:0 /w:[ 1 ]
  //: output g2 (FUNC) @(637,228) /sn:0 /w:[ 0 ]
  //: input g1 (OPR) @(350,114) /sn:0 /w:[ 1 ]
  //: supply1 g32 (w22) @(396,412) /sn:0 /w:[ 0 ]
  and g27 (.I0(w17), .I1(w26), .Z(w16));   //: @(448,489) /sn:0 /w:[ 0 1 0 ]
  concat g19 (.I0(SB), .I1(SA), .Z(OPR));   //: @(398,114) /sn:0 /R:2 /w:[ 1 0 0 ] /dr:0
  //: output g6 (OM2) @(643,517) /sn:0 /w:[ 1 ]
  //: output g7 (MAP) @(640,294) /sn:0 /w:[ 1 ]
  //: supply1 g31 (w13) @(433,411) /sn:0 /w:[ 0 ]
  concat g20 (.I0(w11), .I1(w16), .Z(OM2));   //: @(571,517) /sn:0 /w:[ 0 1 0 ] /dr:0
  tran g15(.Z(w8), .I(IR[6]));   //: @(167,294) /sn:0 /R:3 /w:[ 1 15 16 ] /ss:0
  buf g39 (.I(w4), .Z(COND));   //: @(496,261) /sn:0 /w:[ 1 1 ]
  and g29 (.I0(IR), .I1(w20), .Z(MAP));   //: @(580,294) /sn:0 /w:[ 0 1 0 ]
  tran g25(.Z(w14), .I(IR[7:4]));   //: @(251,294) /sn:0 /R:3 /w:[ 0 9 10 ] /ss:1
  buf g17 (.I(w1), .Z(FUNC));   //: @(495,228) /sn:0 /w:[ 1 1 ]
  concat g42 (.I0(w11), .I1(w26), .Z(w18));   //: @(393,517) /sn:0 /R:2 /w:[ 1 0 1 ] /dr:1
  tran g14(.Z(w17), .I(IR[7]));   //: @(196,294) /sn:0 /R:3 /w:[ 5 13 14 ] /ss:0
  //: output g5 (OM1) @(639,187) /sn:0 /w:[ 1 ]
  tran g36(.Z(w24), .I(IR[5]));   //: @(219,294) /sn:0 /R:3 /w:[ 0 11 12 ] /ss:0
  and g24 (.I0(w15), .I1(w10), .Z(OM1));   //: @(501,187) /sn:0 /w:[ 1 1 0 ]
  tran g21(.Z(w18), .I(IR[1:0]));   //: @(356,294) /sn:0 /R:3 /w:[ 0 5 6 ] /ss:0
  //: output g41 (COND) @(637,261) /sn:0 /w:[ 0 ]
  tran g23(.Z(w10), .I(IR[3:2]));   //: @(323,294) /sn:0 /R:3 /w:[ 0 7 8 ] /ss:1
  tran g40(.Z(w4), .I(IR[4:2]));   //: @(430,294) /sn:0 /R:3 /w:[ 0 1 2 ] /ss:1
  nand g35 (.I0(w24), .I1(!w8), .I2(w17), .Z(w25));   //: @(248,404) /sn:0 /w:[ 1 0 3 0 ]
  and g22 (.I0(w14), .Z(w15));   //: @(287,184) /sn:0 /w:[ 1 0 ]
  //: input g0 (IR) @(148,291) /sn:0 /w:[ 17 ]
  //: joint g26 (w17) @(196, 407) /w:[ 2 4 -1 1 ]
  tran g18(.Z(w1), .I(IR[5:1]));   //: @(382,294) /sn:0 /R:3 /w:[ 0 3 4 ] /ss:1
  and g33 (.I0(w25), .I1(w19), .Z(w23));   //: @(290,443) /sn:0 /w:[ 1 0 0 ]
  concat g30 (.I0(w22), .I1(w23), .I2(w13), .Z(w20));   //: @(451,443) /sn:0 /w:[ 1 1 1 0 ] /dr:0

endmodule

module REG16(DIN, SB, _ENA, SA, A, B, CK, _WA, _CLR, _ENB);
//: interface  /sz:(108, 138) /bd:[ Ti0>DIN[15:0](53/108) Li0>_WA(101/138) Li1>_ENB(82/138) Li2>_ENA(66/138) Li3>_CLR(51/138) Li4>SB[3:0](33/138) Li5>SA[3:0](17/138) Li6>CK(118/138) Bo0<B[15:0](80/108) Bo1<A[15:0](32/108) ]
output [15:0] B;    //: /sn:0 {0}(1208,435)(1135,435){1}
//: {2}(1133,433)(1133,336){3}
//: {4}(1131,435)(882,435){5}
//: {6}(880,433)(880,337){7}
//: {8}(878,435)(647,435){9}
//: {10}(645,433)(645,337){11}
//: {12}(643,435)(387,435)(387,340){13}
input CK;    //: /sn:0 {0}(42,403)(292,403){1}
//: {2}(296,403)(402,403)(402,403)(510,403){3}
//: {4}(514,403)(645,403)(645,403)(779,403){5}
//: {6}(783,403)(1002,403)(1002,320)(1052,320){7}
//: {8}(781,401)(781,321)(800,321){9}
//: {10}(512,401)(512,321)(566,321){11}
//: {12}(294,401)(294,324)(307,324){13}
input _CLR;    //: /sn:0 {0}(43,359)(161,359){1}
//: {2}(165,359)(463,359){3}
//: {4}(467,359)(593,359)(593,359)(722,359){5}
//: {6}(726,359)(948,359)(948,248)(1052,248){7}
//: {8}(724,357)(724,249)(800,249){9}
//: {10}(465,357)(465,249)(566,249){11}
//: {12}(163,357)(163,252)(307,252){13}
output [15:0] A;    //: /sn:0 {0}(1210,467)(1087,467){1}
//: {2}(1085,465)(1085,336){3}
//: {4}(1083,467)(834,467){5}
//: {6}(832,465)(832,337){7}
//: {8}(830,467)(600,467){9}
//: {10}(598,465)(598,337){11}
//: {12}(596,467)(339,467)(339,340){13}
input _ENA;    //: /sn:0 {0}(222,461)(222,453)(35,453){1}
input [3:0] SB;    //: /sn:0 {0}(78,628)(36,628){1}
input [3:0] SA;    //: /sn:0 {0}(77,525)(33,525){1}
input _ENB;    //: /sn:0 {0}(222,561)(222,555)(35,555){1}
input _WA;    //: /sn:0 {0}(42,379)(277,379){1}
//: {2}(281,379)(388,379)(388,379)(498,379){3}
//: {4}(502,379)(633,379)(633,379)(767,379){5}
//: {6}(771,379)(989,379)(989,303)(1052,303){7}
//: {8}(769,377)(769,304)(800,304){9}
//: {10}(500,377)(500,304)(566,304){11}
//: {12}(279,377)(279,307)(307,307){13}
input [15:0] DIN;    //: /sn:0 {0}(116,156)(358,156){1}
//: {2}(362,156)(617,156){3}
//: {4}(621,156)(851,156){5}
//: {6}(855,156)(1106,156)(1106,196){7}
//: {8}(853,158)(853,197){9}
//: {10}(619,158)(619,197){11}
//: {12}(360,158)(360,200){13}
wire w46;    //: /sn:0 {0}(238,603)(969,603)(969,285)(1052,285){1}
wire w16;    //: /sn:0 {0}(238,467)(250,467)(250,271)(307,271){1}
wire [1:0] w15;    //: /sn:0 {0}(209,585)(194,585)(194,633)(84,633){1}
wire [1:0] w37;    //: /sn:0 {0}(209,485)(178,485)(178,530)(83,530){1}
wire w25;    //: /sn:0 {0}(238,591)(756,591)(756,286)(800,286){1}
wire w17;    //: /sn:0 {0}(238,567)(274,567)(274,289)(307,289){1}
wire [1:0] w49;    //: /sn:0 {0}(84,623)(140,623){1}
//: {2}(144,623)(447,623){3}
//: {4}(451,623)(705,623){5}
//: {6}(709,623)(935,623)(935,230)(1052,230){7}
//: {8}(707,621)(707,231)(800,231){9}
//: {10}(449,621)(449,231)(566,231){11}
//: {12}(142,621)(142,234)(307,234){13}
wire w10;    //: /sn:0 {0}(238,579)(489,579)(489,286)(566,286){1}
wire w47;    //: /sn:0 {0}(238,503)(955,503)(955,267)(1052,267){1}
wire [1:0] w50;    //: /sn:0 {0}(83,520)(128,520){1}
//: {2}(132,520)(430,520){3}
//: {4}(434,520)(688,520){5}
//: {6}(692,520)(918,520)(918,214)(1052,214){7}
//: {8}(690,518)(690,215)(800,215){9}
//: {10}(432,518)(432,215)(566,215){11}
//: {12}(130,518)(130,218)(307,218){13}
wire w9;    //: /sn:0 {0}(238,479)(478,479)(478,268)(566,268){1}
wire w26;    //: /sn:0 {0}(238,491)(741,491)(741,268)(800,268){1}
//: enddecls

  //: joint g8 (w49) @(449, 623) /w:[ 4 10 3 -1 ]
  //: joint g4 (w50) @(432, 520) /w:[ 4 10 3 -1 ]
  //: joint g37 (B) @(645, 435) /w:[ 9 10 12 -1 ]
  //: joint g34 (A) @(598, 467) /w:[ 9 10 12 -1 ]
  //: joint g13 (w49) @(707, 623) /w:[ 6 8 5 -1 ]
  //: joint g3 (w50) @(130, 520) /w:[ 2 12 1 -1 ]
  concat g1 (.I0(w50), .I1(w37), .Z(SA));   //: @(78,525) /sn:0 /R:2 /w:[ 0 1 0 ] /dr:0
  //: joint g16 (_CLR) @(724, 359) /w:[ 6 8 5 -1 ]
  //: input g11 (DIN) @(114,156) /sn:0 /w:[ 0 ]
  //: joint g28 (CK) @(781, 403) /w:[ 6 8 5 -1 ]
  //: input g10 (SB) @(34,628) /sn:0 /w:[ 1 ]
  //: input g32 (_ENA) @(33,453) /sn:0 /w:[ 1 ]
  //: joint g27 (CK) @(512, 403) /w:[ 4 10 3 -1 ]
  demux g19 (.I(w15), .E(!_ENB), .Z0(!w17), .Z1(!w10), .Z2(!w25), .Z3(!w46));   //: @(222,585) /sn:0 /R:1 /w:[ 0 0 0 0 0 0 ]
  ZREG4 RF0 (.DIN(DIN), .CK(CK), ._WA(_WA), ._ENB(w17), ._ENA(w16), ._CLR(_CLR), .SB(w49), .SA(w50), .B(B), .A(A));   //: @(308, 201) /sz:(107, 138) /p:[ Ti0>13 Li0>13 Li1>13 Li2>1 Li3>1 Li4>13 Li5>13 Li6>13 Bo0<13 Bo1<13 ]
  //: joint g38 (B) @(880, 435) /w:[ 5 6 8 -1 ]
  //: joint g6 (w50) @(690, 520) /w:[ 6 8 5 -1 ]
  //: joint g7 (w49) @(142, 623) /w:[ 2 12 1 -1 ]
  //: input g9 (SA) @(31,525) /sn:0 /w:[ 1 ]
  //: joint g31 (DIN) @(853, 156) /w:[ 6 -1 5 8 ]
  //: joint g15 (_CLR) @(465, 359) /w:[ 4 10 3 -1 ]
  //: joint g39 (B) @(1133, 435) /w:[ 1 2 4 -1 ]
  //: joint g29 (DIN) @(360, 156) /w:[ 2 -1 1 12 ]
  //: joint g25 (_WA) @(769, 379) /w:[ 6 8 5 -1 ]
  demux g17 (.I(w37), .E(!_ENA), .Z0(!w16), .Z1(!w9), .Z2(!w26), .Z3(!w47));   //: @(222,485) /sn:0 /R:1 /w:[ 0 0 0 0 0 0 ]
  //: joint g14 (_CLR) @(163, 359) /w:[ 2 12 1 -1 ]
  concat g5 (.I0(w49), .I1(w15), .Z(SB));   //: @(79,628) /sn:0 /R:2 /w:[ 0 1 0 ] /dr:0
  REG4 RF3 (.DIN(DIN), .SA(w50), .SB(w49), ._CLR(_CLR), ._ENA(w47), ._ENB(w46), ._WA(_WA), .CK(CK), .A(A), .B(B));   //: @(1053, 197) /sz:(109, 138) /p:[ Ti0>7 Li0>7 Li1>7 Li2>7 Li3>1 Li4>1 Li5>7 Li6>7 Bo0<3 Bo1<3 ]
  //: joint g36 (A) @(1085, 467) /w:[ 1 2 4 -1 ]
  //: joint g24 (_WA) @(500, 379) /w:[ 4 10 3 -1 ]
  //: output g41 (A) @(1207,467) /sn:0 /w:[ 0 ]
  //: joint g23 (_WA) @(279, 379) /w:[ 2 12 1 -1 ]
  //: output g40 (B) @(1205,435) /sn:0 /w:[ 0 ]
  REG4 RF1 (.DIN(DIN), .CK(CK), ._WA(_WA), ._ENB(w10), ._ENA(w9), ._CLR(_CLR), .SB(w49), .SA(w50), .B(B), .A(A));   //: @(567, 198) /sz:(106, 138) /p:[ Ti0>11 Li0>11 Li1>11 Li2>1 Li3>1 Li4>11 Li5>11 Li6>11 Bo0<11 Bo1<11 ]
  //: joint g35 (A) @(832, 467) /w:[ 5 6 8 -1 ]
  //: joint g26 (CK) @(294, 403) /w:[ 2 12 1 -1 ]
  //: input g22 (CK) @(40,403) /sn:0 /w:[ 0 ]
  //: input g18 (_WA) @(40,379) /sn:0 /w:[ 0 ]
  //: input g12 (_CLR) @(41,359) /sn:0 /w:[ 0 ]
  //: input g33 (_ENB) @(33,555) /sn:0 /w:[ 1 ]
  //: joint g30 (DIN) @(619, 156) /w:[ 4 -1 3 10 ]
  REG4 RF2 (.DIN(DIN), .SA(w50), .SB(w49), ._CLR(_CLR), ._ENA(w26), ._ENB(w25), ._WA(_WA), .CK(CK), .A(A), .B(B));   //: @(801, 198) /sz:(107, 138) /p:[ Ti0>9 Li0>9 Li1>9 Li2>9 Li3>1 Li4>1 Li5>9 Li6>9 Bo0<7 Bo1<7 ]

endmodule

module main;    //: root_module
wire w32;    //: /sn:0 {0}(589,382)(659,382){1}
wire [3:0] w45;    //: /sn:0 {0}(589,142)(659,142){1}
wire [3:0] w46;    //: /sn:0 {0}(589,157)(659,157){1}
wire w56;    //: /sn:0 {0}(589,324)(659,324){1}
wire w38;    //: /sn:0 {0}(455,197)(394,197){1}
wire [7:0] w51;    //: /sn:0 {0}(589,237)(659,237){1}
wire w0;    //: /sn:0 {0}(455,310)(394,310){1}
wire w37;    //: /sn:0 {0}(455,212)(394,212){1}
wire w34;    //: /sn:0 {0}(589,420)(659,420){1}
wire w43;    //: /sn:0 {0}(455,260)(394,260){1}
wire w54;    //: /sn:0 {0}(589,289)(659,289){1}
wire w58;    //: /sn:0 {0}(589,363)(659,363){1}
wire [15:0] DATA;    //: /dp:5 {0}(727,478)(727,525)(519,525){1}
//: {2}(517,523)(517,478){3}
//: {4}(515,525)(328,525)(328,478){5}
wire w41;    //: /sn:0 {0}(455,149)(394,149){1}
wire w36;    //: /sn:0 {0}(455,228)(394,228){1}
wire w40;    //: /sn:0 {0}(455,166)(394,166){1}
wire w35;    //: /sn:0 {0}(589,438)(659,438){1}
wire w59;    //: /sn:0 {0}(455,295)(394,295){1}
wire w53;    //: /sn:0 {0}(589,275)(659,275){1}
wire clk;    //: /dp:4 {0}(694,123)(694,66)(494,66){1}
//: {2}(490,66)(303,66){3}
//: {4}(299,66)(148,66){5}
//: {6}(301,68)(301,123){7}
//: {8}(492,68)(492,123){9}
wire w57;    //: /sn:0 {0}(589,344)(659,344){1}
wire [1:0] w49;    //: /sn:0 {0}(589,205)(659,205){1}
wire w44;    //: /sn:0 {0}(455,244)(394,244){1}
wire w52;    //: /sn:0 {0}(589,257)(659,257){1}
wire [1:0] w48;    //: /sn:0 {0}(589,189)(659,189){1}
wire w33;    //: /sn:0 {0}(589,400)(659,400){1}
wire _reset;    //: /dp:4 {0}(749,123)(749,31)(543,31){1}
//: {2}(539,31)(353,31){3}
//: {4}(349,31)(154,31){5}
//: {6}(351,33)(351,123){7}
//: {8}(541,33)(541,123){9}
wire w47;    //: /sn:0 {0}(589,174)(659,174){1}
wire [4:0] w50;    //: /sn:0 {0}(589,219)(659,219){1}
wire w42;    //: /sn:0 {0}(455,279)(394,279){1}
wire w55;    //: /sn:0 {0}(589,306)(659,306){1}
wire w39;    //: /sn:0 {0}(455,181)(394,181){1}
//: enddecls

  //: joint g4 (DATA) @(517, 525) /w:[ 1 2 4 -1 ]
  //: comment g8 /dolink:1 /link:"@C/menagerie.gm" @(17,366) /sn:0
  //: /line:"* Microcode/Macrocode Definitions"
  //: /end
  //: joint g3 (_reset) @(541, 31) /w:[ 1 -1 2 8 ]
  //: comment g13 /dolink:0 /link:"" @(17,448) /sn:0
  //: /line:"Circuit highlights:"
  //: /end
  //: joint g2 (clk) @(492, 66) /w:[ 1 -1 2 8 ]
  //: comment g1 /dolink:0 /link:"" @(17,104)
  //: /line:"This circuit is a simple"
  //: /line:"microprocessor.  A simulation"
  //: /line:"script will cause it to start"
  //: /line:"executing the \"Animals\" game as"
  //: /line:"soon as you start simulation"
  //: /line:"mode. Click on the various"
  //: /line:"logic blocks and press the '>'"
  //: /line:"key to look at the sub-circuits"
  //: /line:"inside.  You can return to the"
  //: /line:"parent module by pressing"
  //: /line:"the '<' key.  While in simulation"
  //: /line:"mode, click on a wire to see"
  //: /line:"its current value,"
  //: /line:"or double-click to set a trace."
  //: /line:""
  //: /line:"Auxilary files associated with"
  //: /line:"this circuit can be found in the"
  //: /line:"examples/ex4 subdirectory of the"
  //: /line:"TkGate library directory.  Click"
  //: /line:"on the links below to view their"
  //: /line:"contents."
  //: /end
  //: comment g16 /dolink:1 /link:"#eunit.alu" @(17,510) /sn:0
  //: /line:"* ALU"
  //: /end
  //: comment g11 /dolink:1 /link:"@C/menagerie.gss" @(17,406) /sn:0
  //: /line:"* Simulator Script"
  //: /end
  //: comment g10 /dolink:1 /link:"@C/menagerie.mem" @(17,386) /sn:0
  //: /line:"* Memory Initialization File"
  //: /end
  IUNIT iunit (._CLR(_reset), .CK(clk), .IR(DATA), .COUT(w35), ._Z(w34), ._GT(w33), ._LT(w32), ._rdpc(w59), ._incmar(w0), ._rd(w44), .spc(w43), ._ldhmdr(w42), ._ldpc(w41), ._ldmar(w40), ._ldmdr(w39), ._incpc(w38), ._rdmdr(w37), ._wrt(w36), ._DOUT(w58), ._LDQL(w57), ._LDQH(w56), ._LDDATA(w55), .CIN(w54), ._LDQ(w53), ._CLQ(w52), .IDATA(w51), .FUNC(w50), .BOP(w49), .AOP(w48), ._WA(w47), .SB(w46), .SA(w45));   //: @(456, 124) /sz:(132, 353) /p:[ Ti0>9 Ti1>9 Bi0>3 Ri0>0 Ri1>0 Ri2>0 Ri3>0 Lo0<0 Lo1<0 Lo2<0 Lo3<0 Lo4<0 Lo5<0 Lo6<0 Lo7<0 Lo8<0 Lo9<0 Lo10<0 Ro0<0 Ro1<0 Ro2<0 Ro3<0 Ro4<0 Ro5<0 Ro6<0 Ro7<0 Ro8<0 Ro9<0 Ro10<0 Ro11<0 Ro12<0 Ro13<0 ]
  //: joint g6 (_reset) @(351, 31) /w:[ 3 -1 4 6 ]
  //: comment g9 /dolink:0 /link:"" @(23,54)
  //: /line:"This is the"
  //: /line:"system clock."
  //: /line:" "
  //: /end
  //: comment g7 /dolink:0 /link:"" @(20,17) /sn:0
  //: /line:"This is the"
  //: /line:"reset switch."
  //: /end
  //: comment g15 /dolink:1 /link:"#iunit.mpc" @(17,487) /sn:0
  //: /line:"* Micro Program Counter"
  //: /end
  MEMORY memory (._CLR(_reset), .CK(clk), ._incmar(w0), ._rdpc(w59), ._ldhmdr(w42), .spc(w43), ._rd(w44), ._wrt(w36), ._rdmdr(w37), ._incpc(w38), ._ldmdr(w39), ._ldmar(w40), ._ldpc(w41), .DATA(DATA));   //: @(268, 124) /sz:(125, 353) /p:[ Ti0>7 Ti1>7 Ri0>1 Ri1>1 Ri2>1 Ri3>1 Ri4>1 Ri5>1 Ri6>1 Ri7>1 Ri8>1 Ri9>1 Ri10>1 Bt0=5 ]
  //: comment g17 /dolink:1 /link:"#memory.m1" @(17,531) /sn:0
  //: /line:"* Main Memory"
  //: /end
  EUNIT eunit (._CLR(_reset), .CK(clk), ._DOUT(w58), ._LDQL(w57), ._LDQH(w56), ._LDDATA(w55), .SA(w45), .CIN(w54), ._LDQ(w53), ._CLQ(w52), .IDATA(w51), .FUNC(w50), .BOP(w49), .AOP(w48), ._WA(w47), .SB(w46), ._LT(w32), ._GT(w33), ._Z(w34), .COUT(w35), .DATA(DATA));   //: @(660, 124) /sz:(128, 353) /p:[ Ti0>0 Ti1>0 Li0>1 Li1>1 Li2>1 Li3>1 Li4>1 Li5>1 Li6>1 Li7>1 Li8>1 Li9>1 Li10>1 Li11>1 Li12>1 Li13>1 Lo0<1 Lo1<1 Lo2<1 Lo3<1 Bt0=0 ]
  //: joint g5 (clk) @(301, 66) /w:[ 3 -1 4 6 ]
  //: comment g14 /dolink:1 /link:"#memory.tty0" @(17,468) /sn:0
  //: /line:"* TTY Device"
  //: /end
  clock g0 (.Z(clk));   //: @(135,66) /sn:0 /w:[ 5 ] /omega:300 /phi:0 /duty:50
  //: comment g18 /dolink:1 /link:"#memory.PC" @(17,551) /sn:0
  //: /line:"* Program Counter"
  //: /end
  //: switch reset (_reset) @(137,31) /sn:0 /w:[ 5 ] /st:1
  //: comment g12 /dolink:1 /link:"@C/menagerie.map" @(17,426) /sn:0
  //: /line:"* Symbol Map"
  //: /end

endmodule

module EUNIT(_LDDATA, _CLR, SB, SA, AOP, BOP, _GT, _LDQ, _Z, _WA, CK, _CLQ, DATA, FUNC, _LT, _LDQH, _LDQL, CIN, IDATA, COUT, _DOUT);
//: interface  /sz:(128, 353) /bd:[ Ti0>CK(34/128) Ti1>_CLR(89/128) Li0>SB[3:0](33/353) Li1>_WA(50/353) Li2>AOP[1:0](65/353) Li3>BOP[1:0](81/353) Li4>FUNC[4:0](95/353) Li5>IDATA[7:0](113/353) Li6>_CLQ(133/353) Li7>_LDQ(150/353) Li8>CIN(165/353) Li9>SA[3:0](18/353) Li10>_LDDATA(182/353) Li11>_LDQH(200/353) Li12>_LDQL(220/353) Li13>_DOUT(239/353) Lo0<COUT(314/353) Lo1<_Z(296/353) Lo2<_GT(276/353) Lo3<_LT(258/353) Bt0=DATA[15:0](67/128) ]
output _Z;    //: /sn:0 {0}(646,543)(608,543){1}
input _CLQ;    //: /sn:0 {0}(549,811)(497,811){1}
output _LT;    //: /sn:0 {0}(645,575)(608,575){1}
input _LDQH;    //: /sn:0 {0}(837,798)(837,771)(810,771){1}
input CK;    //: /sn:0 {0}(498,352)(195,352)(195,407){1}
//: {2}(193,409)(186,409)(186,409)(185,409){3}
//: {4}(195,411)(195,829)(535,829){5}
//: {6}(539,829)(583,829){7}
//: {8}(537,831)(537,855)(724,855){9}
input CIN;    //: /sn:0 {0}(475,618)(499,618){1}
input _CLR;    //: /sn:0 {0}(308,285)(379,285){1}
//: {2}(383,285)(498,285){3}
//: {4}(381,287)(381,789)(522,789)(522,806)(549,806){5}
supply0 w0;    //: /sn:0 {0}(498,300)(463,300)(463,314){1}
//: {2}(465,316)(498,316){3}
//: {4}(463,318)(463,321){5}
input [4:0] FUNC;    //: /sn:0 {0}(477,541)(499,541){1}
inout [15:0] DATA;    //: /sn:0 {0}(997,676)(961,676){1}
//: {2}(959,674)(959,437)(866,437){3}
//: {4}(864,435)(864,414){5}
//: {6}(862,437)(610,437){7}
//: {8}(606,437)(474,437)(474,463){9}
//: {10}(608,439)(608,465){11}
//: {12}(957,676)(916,676){13}
input [3:0] SB;    //: /sn:0 {0}(310,267)(498,267){1}
input _LDDATA;    //: /sn:0 {0}(877,398)(907,398)(907,389){1}
input [1:0] AOP;    //: /sn:0 {0}(420,479)(457,479){1}
input _LDQ;    //: /sn:0 {0}(673,739)(706,739){1}
//: {2}(710,739)(738,739){3}
//: {4}(708,741)(708,755){5}
//: {6}(708,759)(708,766)(708,766)(708,772){7}
//: {8}(710,757)(842,757)(842,798){9}
input [3:0] SA;    //: /sn:0 {0}(310,251)(498,251){1}
input _WA;    //: /sn:0 {0}(498,335)(313,335){1}
input _DOUT;    //: /sn:0 {0}(908,671)(908,644){1}
supply0 [7:0] w30;    //: /sn:0 {0}(299,388)(299,378)(331,378)(331,413)(369,413){1}
input [1:0] BOP;    //: /sn:0 {0}(555,481)(591,481){1}
input _LDQL;    //: /sn:0 {0}(703,772)(703,764)(679,764){1}
output _GT;    //: /sn:0 {0}(645,560)(608,560){1}
input [7:0] IDATA;    //: /sn:0 {0}(369,423)(298,423){1}
output COUT;    //: /sn:0 {0}(645,592)(608,592){1}
wire w7;    //: /sn:0 {0}(840,819)(840,860)(800,860){1}
wire [15:0] w38;    //: /sn:0 {0}(480,492)(480,502)(531,502)(531,522){1}
wire [15:0] w21;    //: /sn:0 {0}(496,893)(292,893)(292,452)(460,452){1}
//: {2}(464,452)(596,452)(596,465){3}
//: {4}(462,454)(462,463){5}
wire [15:0] w31;    //: /sn:0 {0}(614,494)(614,509)(579,509)(579,522){1}
wire [15:0] w28;    //: /sn:0 {0}(632,465)(632,406)(579,406)(579,373){1}
wire [15:0] w36;    //: /sn:0 {0}(498,463)(498,406)(531,406)(531,373){1}
wire [15:0] w1;    //: /sn:0 {0}(900,676)(846,676){1}
//: {2}(844,674)(844,414){3}
//: {4}(842,676)(771,676){5}
//: {6}(770,676)(678,676){7}
//: {8}(677,676)(556,676)(556,651){9}
wire [7:0] QL;    //: /sn:0 {0}(502,888)(620,888)(620,840){1}
wire [7:0] QH;    //: /sn:0 {0}(502,898)(761,898)(761,866){1}
wire [7:0] w8;    //: /sn:0 {0}(620,819)(620,710)(769,710){1}
//: {2}(771,708)(771,680){3}
//: {4}(771,712)(771,723){5}
wire [15:0] w35;    //: /sn:0 {0}(486,463)(486,420){1}
//: {2}(488,418)(620,418)(620,465){3}
//: {4}(484,418)(375,418){5}
wire [15:0] DIN;    //: /sn:0 {0}(854,385)(854,169)(552,169)(552,233){1}
wire [7:0] w2;    //: /sn:0 {0}(761,752)(761,845){1}
wire [7:0] w12;    //: /sn:0 {0}(678,680)(678,700)(751,700)(751,723){1}
wire w10;    //: /sn:0 {0}(659,824)(669,824)(669,811){1}
//: {2}(671,809)(810,809)(810,850)(800,850){3}
//: {4}(667,809)(570,809){5}
wire w9;    //: /sn:0 {0}(659,834)(706,834)(706,793){1}
//: enddecls

  //: supply0 g4 (w0) @(463,327) /sn:0 /w:[ 5 ]
  mux g8 (.I0(w1), .I1(DATA), .S(!_LDDATA), .Z(DIN));   //: @(854,398) /sn:0 /R:2 /w:[ 3 5 0 0 ]
  concat g37 (.I0(QL), .I1(QH), .Z(w21));   //: @(497,893) /sn:0 /R:2 /w:[ 0 0 0 ] /dr:0
  //: input g34 (_LDDATA) @(907,387) /sn:0 /R:3 /w:[ 1 ]
  //: input g3 (_CLR) @(306,285) /sn:0 /w:[ 0 ]
  concat g13 (.I0(IDATA), .I1(w30), .Z(w35));   //: @(374,418) /sn:0 /w:[ 0 1 5 ] /dr:0
  //: input g2 (SB) @(308,267) /sn:0 /w:[ 0 ]
  //: input g1 (SA) @(308,251) /sn:0 /w:[ 0 ]
  //: input g11 (AOP) @(418,479) /sn:0 /w:[ 0 ]
  //: input g16 (BOP) @(553,481) /sn:0 /w:[ 0 ]
  //: frame g50 @(422,693) /sn:0 /wi:442 /ht:238 /tx:"Q Register Handling"
  //: output g28 (_GT) @(642,560) /sn:0 /w:[ 0 ]
  //: input g10 (_LDQ) @(671,739) /sn:0 /w:[ 0 ]
  mux g19 (.I0(w21), .I1(DATA), .I2(w35), .I3(w36), .S(AOP), .Z(w38));   //: @(480,479) /sn:0 /w:[ 5 9 0 0 1 0 ]
  //: output g27 (_Z) @(643,543) /sn:0 /w:[ 0 ]
  //: joint g32 (_CLR) @(381, 285) /w:[ 2 -1 1 4 ]
  tran g38(.Z(w8), .I(w1[7:0]));   //: @(771,679) /sn:0 /R:3 /w:[ 3 5 6 ] /ss:0
  //: input g6 (_WA) @(311,335) /sn:0 /w:[ 1 ]
  //: input g7 (CK) @(183,409) /sn:0 /w:[ 3 ]
  //: input g9 (_CLQ) @(495,811) /sn:0 /w:[ 1 ]
  //: joint g15 (w21) @(462, 452) /w:[ 2 -1 1 4 ]
  //: inout g20 (DATA) @(1005,676) /sn:0 /R:2 /w:[ 0 ]
  nor g31 (.I0(!_CLR), .I1(!_CLQ), .Z(w10));   //: @(560,809) /sn:0 /w:[ 5 0 5 ]
  REG16 RF (.DIN(DIN), .CK(CK), .SA(SA), .SB(SB), ._CLR(_CLR), ._ENA(w0), ._ENB(w0), ._WA(_WA), .A(w36), .B(w28));   //: @(499, 234) /sz:(108, 138) /p:[ Ti0>1 Li0>0 Li1>1 Li2>1 Li3>3 Li4>0 Li5>3 Li6>0 Bo0<1 Bo1<1 ]
  tran g39(.Z(w12), .I(w1[15:8]));   //: @(678,679) /sn:0 /R:3 /w:[ 0 7 8 ] /ss:0
  ALU alu (.B(w31), .A(w38), .CIN(CIN), .FUNC(FUNC), .OUT(w1), .COUT(COUT), ._LT(_LT), ._GT(_GT), ._Z(_Z));   //: @(500, 523) /sz:(107, 127) /sn:0 /p:[ Ti0>1 Ti1>1 Li0>1 Li1>1 Bo0<9 Ro0<1 Ro1<1 Ro2<1 Ro3<1 ]
  nor g43 (.I0(!_LDQL), .I1(!_LDQ), .Z(w9));   //: @(706,783) /sn:0 /R:3 /w:[ 0 7 1 ]
  register QL (.Q(QL), .D(w8), .EN(w9), .CLR(w10), .CK(CK));   //: @(620,829) /w:[ 1 0 0 0 7 ]
  //: joint g48 (w1) @(844, 676) /w:[ 1 2 4 -1 ]
  register QH (.Q(QH), .D(w2), .EN(w7), .CLR(w10), .CK(CK));   //: @(761,855) /w:[ 1 1 1 3 9 ]
  bufif0 g17 (.Z(DATA), .I(w1), .E(_DOUT));   //: @(906,676) /sn:0 /cpc:1 /w:[ 13 0 0 ]
  //: input g25 (FUNC) @(475,541) /sn:0 /w:[ 0 ]
  //: output g29 (_LT) @(642,575) /sn:0 /w:[ 0 ]
  //: joint g42 (CK) @(537, 829) /w:[ 6 -1 5 8 ]
  //: joint g5 (w0) @(463, 316) /w:[ 2 1 -1 4 ]
  //: supply0 g14 (w30) @(299,394) /sn:0 /w:[ 0 ]
  //: joint g44 (_LDQ) @(708, 739) /w:[ 2 -1 1 4 ]
  //: joint g47 (DATA) @(959, 676) /w:[ 1 2 12 -1 ]
  //: joint g36 (w8) @(771, 710) /w:[ -1 2 1 4 ]
  //: input g24 (_LDQH) @(808,771) /sn:0 /w:[ 1 ]
  //: joint g21 (w35) @(486, 418) /w:[ 2 -1 4 1 ]
  //: joint g41 (CK) @(195, 409) /w:[ -1 1 2 4 ]
  //: input g23 (_LDQL) @(677,764) /sn:0 /w:[ 1 ]
  //: joint g40 (w10) @(669, 809) /w:[ 2 -1 4 1 ]
  //: joint g22 (DATA) @(608, 437) /w:[ 7 -1 8 10 ]
  //: joint g0 (DATA) @(864, 437) /w:[ 3 4 6 -1 ]
  //: joint g46 (_LDQ) @(708, 757) /w:[ 6 5 8 -1 ]
  nor g45 (.I0(!_LDQH), .I1(!_LDQ), .Z(w7));   //: @(840,809) /sn:0 /R:3 /w:[ 0 9 0 ]
  mux g35 (.I0(w12), .I1(w8), .S(_LDQ), .Z(w2));   //: @(761,739) /sn:0 /w:[ 1 5 3 0 ]
  //: input g26 (CIN) @(473,618) /sn:0 /w:[ 0 ]
  //: input g12 (IDATA) @(296,423) /sn:0 /w:[ 1 ]
  mux g18 (.I0(w21), .I1(DATA), .I2(w35), .I3(w28), .S(BOP), .Z(w31));   //: @(614,481) /sn:0 /w:[ 3 11 3 0 1 0 ]
  //: output g30 (COUT) @(642,592) /sn:0 /w:[ 0 ]
  //: input g49 (_DOUT) @(908,642) /sn:0 /R:3 /w:[ 1 ]

endmodule
